;;;;;;;;;;;;
;; This is the case for undirected graphs, genome is created by strictly upper triangular matrixes;;
;;;;;;;;;;;;

;;;;;;;;;;;;
;; Breeds ;;
;;;;;;;;;;;;

  ;; nodes and edges between nodes, are all turtles
  ;; edges are not necessarily symmetric
breed [ nodes node ]
breed [ edges edge ]


;;;;;;;;;;;;;;;
;; Variables ;;
;;;;;;;;;;;;;;;

globals [
   
  clock
  list-of-nodes   ;; nodes ordered by reservation price
  nodes-in-round  ;; nodes who have bought a product in the session
  avg-information-value
  nodos-accesibles
               
    ;; average number of nodes reachable by each buyer
    ;; in an infinite number of steps
  avg-accessibility
  
    ;; variable for drag-and-drop procedure
  clicked-node      ;; buyer who was clicked on
  path
  my-random-seed
  basic-genome 
  topology
  strict-upper-triang
  topology-random
  sum-fitness
  ranking
  empty-topology
  complete-topology
  density
  sum-links 
   
    ;; genetic algorithm variables
  generation
         
        edge-cost
         fitlist
         edgelist
         best-fitness
         avg-fitness
         avg-dir
         avg-ind
         max-profits
         profits
         net-indirect-benefit
         net-direct-benefit
         global-fitness
         seed-genomes
         mix-genes
         chosen-size
         genome-size
         best-genome
         adjacency-matrix     
         ;indirect-info
         transitive-matrix
         
          genome-list 
          topology-list

          random-wife1
          random-wife2
          random-husband1
          random-husband2
          winner-list
 ]

nodes-own [
    ;; stores the list of nodes that this particular buyer edges to
  edgeees
    ;; these variables are used to do the layout
  force-x
  force-y
         genome           
           fitness
           own-information
           direct-information
           indirect-info
           indirect-information
           direct-edgeing-costs
           indirect-edgeing-costs
                     
            origin
            destination  
          ]

  ;; The direction of the edge does matter in this model.
edges-own [
        origin 
        destination
         ]

;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Nodes Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;

  ;; accessibility is the number of social neighbours that the node could reach in a 
  ;; number of steps equal to "num-steps". For instance, if buyer A edges only to buyer B, 
  ;; who edges only to buyer C, who has no social neighbours, then A's accessibility 
  ;; in one step is 1, and in two steps is 2; B's accessibility in any number of steps is 1, 
  ;; and C's accessibility in any number of steps is 0.
  ;; This is what I need for counting accumulative edgeing costs!!

to-report accessibility [num-steps]
  set nodos-accesibles []
  let step 1
  let reachable-nodes edgeees
  let old-length 0
  let new-length length reachable-nodes
  while [ new-length != old-length and step < num-steps]
        [ set old-length new-length
          set reachable-nodes 
            remove-duplicates sentence 
              reachable-nodes 
              reduce [sentence ?1 ?2] map [ [edgeees] of ?] reachable-nodes 
          set new-length (length reachable-nodes)
          set nodos-accesibles fput reachable-nodes nodos-accesibles
          set step (step + 1)
        ]
        
  set path new-length - ifelse-value (member? self reachable-nodes) [1] [0]
  report path
  
end

to-report accessibility-by-node [tag-node num-steps]
  let step 1
  let node-zero node tag-node
  let reachable-nodes [edgeees] of node-zero
  let old-length 0
  let new-length length reachable-nodes
  while [ new-length != old-length and step < num-steps]
        [ set old-length new-length
          set reachable-nodes 
            remove-duplicates sentence 
              reachable-nodes 
              reduce [sentence ?1 ?2] map [ [edgeees] of node ?] reachable-nodes 
          set new-length (length reachable-nodes)
          set step (step + 1)
        ]        
  set path new-length - ifelse-value (member? self reachable-nodes) [1] [0]
  report path
  
end


;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to startup
  
  ask patches [set pcolor white - .15]
  
end

to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks 
;  random-seed random-normal 4 1
  set topology-list []
  set density 0
  ct
  ask patches [set pcolor black - .15]
  set-default-shape edges "line"  
  set avg-fitness 0
  set best-fitness 0
  repeat generations * .02 [ 
  create-initial-genetic-info
  sort-global-fitness
  build-ga-network item 0 topology-list
  set best-fitness item compute-factorial num-nodes item 0 topology-list
  plot-density
  ]
  
end

to make-nodes
  set-default-shape nodes "circle"
 let colornode 0
;; create nodes and provide them with initial endowment of information
  create-ordered-nodes num-nodes [
    set size .6
     if B&W [
    set color colornode ]
    
    if information-endowment = "deterministic"
      [set own-information value-of-info]
    if information-endowment = "random"  
      [set own-information random-normal value-of-info 1]
    set edgeees []  ;; empty list
      ;; nodes are automatically created with evenly spaced headings,
      ;; so if they just move forward they will form a circle
    fd max-pxcor - 2
    if colornode > 9 [set colornode 0]
    set colornode colornode + .5
     ]
  if information-endowment = "heterogeneous"  
 [   
      
       let lista-valores (list 1 2 3 4 5 6 7 8 10 11 12 13 14 15 16 17 18 
        19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35) 
       ask nodes [set own-information item who lista-valores
        set label (word own-information "c " )
        set label-color black
        set plabel-color red] 
  ]   
        
end


to create-initial-genetic-info
  ct
  set fitlist []

  make-nodes
  create-genome

  warshall ;; aca se forman adjacency y transitive
  indirect-information-matrix
  update-transitive-matrix
  
  calculate-profits  
;  show (word basic-genome  " bg")   
    let genome-reduction (list reduce [sentence ?1 ?2] basic-genome)
    set genome-reduction reduce [sentence ?1 ?2] genome-reduction 
    set genome-reduction fput genome-reduction fitlist
    let incoming reduce [sentence ?1 ?2] genome-reduction
    ;;show incoming    
    set topology-list lput incoming topology-list 

end 

to create-genetic-info
  ct

  set genome-list []
  set fitlist []
  make-nodes
  theory-driven
  update-genome ;; here is where seed-genomes become nodes' genome again
  warshall
  indirect-information-matrix
  update-transitive-matrix
  
  calculate-profits  
;  show (word seed-genomes  " sg")
  let genome-reduction (list reduce [sentence ?1 ?2] seed-genomes)
  set genome-reduction reduce [sentence ?1 ?2] seed-genomes

  set genome-reduction fput seed-genomes fitlist
  let incoming reduce [sentence ?1 ?2] genome-reduction
  set topology-list lput incoming topology-list
  
end 

;;;;;;;;;;;;;;;;;;;;;;
;;; Main Procedure ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;

to go

    set generation (generation + 1)
    if (generation > generations ) [export stop]
    
    do-best-of-age-plot
    plot-density
    mate-recombine
    mutate
    rebirth
         
end
 
 
  
;;;;;;;;;;;;;;;;;;;;;;;
;;; edge Operations ;;;
;;;;;;;;;;;;;;;;;;;;;;;


to build-ga-network [adjacency]
 ;; Nodes randomly are provided with their connection's structure. This is a node procedure.
no-display
;show adjacency 
ask nodes [set genome n-values num-nodes [0]]
 ;; Ahora, copia esos datos y se lo inserta en los genomas de los nodos respectivos (la diagonal principal nunca es usada)
 let y 0
 let f 0
  while [y < (num-nodes - 1)] ;; recorro todos los nodos menos el _ltimo
   [let g y + 1
    while [g < num-nodes] ;; de cada nodo, tengo que llegar al final del genome
     [ask node y [set genome replace-item g genome item f adjacency] 
      set g g + 1
      set f f + 1] 
      set y y + 1
     ]


     
;; se completa la diagonal inferior para todos los nodos, simetrica a la superior
let i 0
let j 0

   while [i < num-nodes ][set j 0
     while [j < num-nodes ][
      if (item j [genome] of node i = 1)
        [ask node j [set genome replace-item i genome 1]
         ]
      set j j + 1]
   set i i + 1]


; let a 0
;while [a < num-nodes]
;   [ask node a [show genome]
;    set a a + 1 ]
    

  set j 0
  set i 0  ;; agregu_ un contador i porque me parece que cuenta a cada nodo su conexi_n pero no recorre todos los nodos.
  
  while [i < num-nodes ]
          [set j 0
           while [j < num-nodes ]
           [if (item j [genome] of node i = 1)
               [make-edge node i node j ]
          set j j + 1]
      set i i + 1
    ]
  plot-accessibility
display
end


to calculate-profits
;; Nodes procedure 
ask nodes [
 set direct-edgeing-costs 0
 set direct-information own-information
 set indirect-information 0
 set indirect-edgeing-costs 0
 set net-direct-benefit 0
 set net-indirect-benefit 0
 set profits 0
 set edge-cost own-information / ratio-info-edge 
 set genome (replace-item who genome 0)]
;; iterate over the nodes and ask them for their "direct" costs and information benefits
  
let j 0
let k 0
  while [j < num-nodes]
   [set k 0
    while [k < num-nodes]
      [ask node j [if (item k genome = 1)
                   [ifelse decay [set direct-information direct-information + (rate-of-decay * [own-information] of node k)]
                                 [set direct-information direct-information + [own-information] of node k] 
                    set direct-edgeing-costs direct-edgeing-costs + (edge-cost / 2) ]]
             set k k + 1]
     set j j + 1] 
             
set j 0

  while [j < num-nodes]
   [set k 0
    while [k < num-nodes]
     [ask node j [ifelse (item k indirect-info > 0)
                 [ifelse decay [set indirect-information indirect-information + ([direct-information] of node k * (rate-of-decay ^ item k indirect-info))]
                               [set indirect-information indirect-information + [direct-information] of node k] 
                  set indirect-edgeing-costs indirect-edgeing-costs + (item k indirect-info * ( edge-cost / 2 ))]
                  [set indirect-information indirect-information 
                   set indirect-edgeing-costs indirect-edgeing-costs]]       
        set k k + 1]
     set j j + 1]

ask nodes [
      if edge-Cost-Structure = "direct cost direct info"
        [set indirect-information 0  set indirect-edgeing-costs 0]
      if edge-Cost-Structure = "direct cost indirect info"
        [set indirect-edgeing-costs 0]
      if edge-Cost-Structure = "indirect cost direct info"
        [set indirect-information 0]
      if edge-Cost-Structure = "indirect cost indirect info"
        []
  ]  
     

      
 ;; viene del primer ask nodes
;; obtain now the total costs of individuals

 set net-direct-benefit sum [direct-information] of nodes - sum [direct-edgeing-costs] of nodes
 set net-indirect-benefit sum [indirect-information] of nodes - sum [indirect-edgeing-costs] of nodes 
 set profits precision (net-indirect-benefit + net-direct-benefit) 3

 set avg-ind smoothness * avg-ind + (1 - smoothness) * net-indirect-benefit  
 set avg-dir smoothness * avg-dir + (1 - smoothness) * net-direct-benefit 

 let max-links num-nodes * (num-nodes - 1) 
 set density sum-links / max-links

 set fitlist lput profits fitlist
 
 plot-direct-profits
 plot-indirect-profits 
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; edge procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The algorithm for the following procedure has been borrowed from the 
;; model "Giant Component", in the "Models library".
;; The copyright for this procedure is included at the bottom of this file

  ;; makes a edge from edgeer to edgeee
to make-edge [edgeer edgeee]
  if member? edgeee [edgeees] of edgeer
  [
    user-message (word "There is already a edge from " edgeer " to " edgeee)
    stop
  ]
  create-edges 1
  [
    set origin edgeer
    set destination edgeee
    if show-network-evolution [
    set color [color] of edgeer
    reposition-edge]
    ;set direct-edgeing-costs direct-edgeing-costs + edge-cost
  ]
  
  
    ;; add edgeee to the edgeer's list of edgeees
;  set [edgeees] of edgeer fput edgeee [edgeees] of edgeer
  ask edgeer [ set edgeees fput edgeee edgeees ]
end

to delete-edge [edgeer edgeee]
  ifelse (member? edgeee [edgeees] of edgeer)
  [
    ask edges [die]
  ]
  [
    user-message (word "There is no edge from " edgeer " to " edgeee)
    stop
  ]
  
  create-edges 1
  [
    set origin edgeer
    set destination edgeee
    if show-network-evolution [
    set color [color] of edgeer
    reposition-edge]
  ]
    ;; add edgeee to the edgeer's list of edgeees
;  set [edgeees] of edgeer fput edgeee [edgeees] of edgeer
  ask edgeer [ set edgeees fput edgeee edgeees ]

end


;; The algorithm for the following procedure has been borrowed from the 
;; model "Giant Component", in the "Models library".
;; The copyright for this procedure is included at the bottom of this file

  ;; repositions and resizes the edge according to the position of the
  ;; nodes
to reposition-edge  ;; edge procedure
  setxy ([xcor] of origin) ([ycor] of origin)
  set size distance-nowrap destination
    ;; watch out for special case where origin and destination are
    ;; at the same place
  if size != 0
  [
      ;; position edge at midpoint between origin and destination
    set heading towards-nowrap destination
    jump size / 2
  ]
end

;;;;;;;;;;;;;;;;
;;; Plotting ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;

to plot-accessibility
  let steps accessibility-steps
  let accessibility-by-node-list []

    if accessibility-steps = "Infinity" [set steps num-nodes]

  ;; you cannot sort agents because that creates a list that is not processable as is. 
  let accessibility-list [accessibility steps] of nodes 
  

  let max-accessibility max accessibility-list
  set-current-plot "Accessibility Distribution"
  set-plot-x-range 0 (max-accessibility + 1)  ;; + 1 to make room for the width of the last bar
  histogram accessibility-list
  
 ;set accessibility-by-node-list values-from nodes [accessibility-by-node i steps]

end

to plot-direct-profits
  auto-plot-on
  set-current-plot "Direct Benefits"
  set-current-plot-pen "net-direct-benefits"  
  plot net-direct-benefit
  set-current-plot-pen "avg-dir"  
  plot avg-dir

end

to plot-indirect-profits
auto-plot-on

  set-current-plot "Indirect Benefits"
  set-current-plot-pen "net-indirect-benefits"  
  plot net-indirect-benefit
  set-current-plot-pen "avg-ind"  
  plot avg-ind
end 

to do-best-of-age-plot
    set-current-plot "Best-Average-Profit"
    set-current-plot-pen "Moving-Average"
    plot avg-fitness
    set-current-plot-pen "Best"
    plot best-fitness     
    
end

to plot-density
auto-plot-on
  set-current-plot "Network Density"
  set-current-plot-pen "density"  
  plot density

end 
;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;

;; The algorithm for the following procedure has been borrowed from the 
;; model "Giant Component", in the "Models library".
;; The copyright for this procedure is included at the bottom of this file

to layout
  no-display
    ;; these values are arbitrarily chosen to give a good layout
    ;; for typical model settings
  let spring-constant 0.2
  let natural-length 9.0
  let repulsion-constant 1.0

    ;; reset force-x and force-y
  ask nodes
  [
    set force-x 0
    set force-y 0
  ]

    ;; add the forces due to the springs
  without-interruption     ;; process edges one at a time, not concurrently
  [
    ask edges
    [
      let spring-force (spring-constant * (size - natural-length))
        ;; take care of zero sized spring
      ifelse size = 0
      [
        set spring-force spring-constant * natural-length

          ;; we know force but dont know the direction in which to apply it
          ;; make an arbitrary choice of direction ( postive and negative x direction)
        ask origin
        [set force-x force-x + spring-force]
        ask destination
        [set force-x force-x - spring-force]
      ]
      [
        ask origin
        [
          set force-x force-x + spring-force * sin towards-nowrap [destination] of myself
          set force-y force-y + spring-force * cos towards-nowrap [destination] of myself
        ]
        ask destination
        [
          set force-x force-x + spring-force * sin towards-nowrap [origin] of myself
          set force-y force-y + spring-force * cos towards-nowrap [origin] of myself
        ]
      ]
    ]
  ]

    ;; add a force of repulsion between nodes,
    ;; inversely proportional to square of distance
  without-interruption    ;; process nodes one at a time, not concurrently
  [
      ;; exempt edgeless nodes from the force
    let connected-nodes nodes with [not empty? edgeees]
    ask connected-nodes
    [
      ask connected-nodes with [self != myself]
      [
        let angle 0
        let force 0
        ifelse xcor = [xcor] of myself and ycor = [ycor] of myself
          ;; the two nodes are exactly on top of each other.  theoretically
          ;; this shouldn't occur, but in practice, it might because the world
          ;; is bounded and nodes can get forced into the corners.  not clear
          ;; how to handle this, so just apply a small arbitrary force in a
          ;; random direction.
        [
          set angle random-float 360    ;; arbitrary
          set force repulsion-constant  ;; arbitrary
        ]
          ;; normal case where nodes aren't on top of each other
        [
          set angle towards-nowrap myself
          set force repulsion-constant / ((distance-nowrap myself) ^ 2)
        ]
        set force-x force-x - force * sin angle
        set force-y force-y - force * cos angle
      ]
    ]
  ]

    ;; actually move the nodes
  ask nodes
  [
      ;; the current layout scheme has an issue where
      ;; sometimes heavily connected nodes are thrown back and forth.
      ;; to prevent that we cap the movement of nodes
    ifelse force-x > 1
    [ set force-x 1 ]
    [
      if force-x < -1
      [set force-x -1]
    ]
    ifelse force-y > 1
    [ set force-y 1 ]
    [
      if force-y < -1
      [set force-y -1]
    ]
    move (xcor + force-x) (ycor + force-y)
  ]
    ;; reposition all the edges
  ask edges [ reposition-edge ]
    ;; update the display, for smooth animation
  display
end

  ;; move, but take care not to wrap around edge of world
to move [x y]  ;; buyer procedure
  ifelse x > max-pxcor
    [ set x max-pxcor ]
    [ if x < min-pxcor
      [ set x min-pxcor ] ]
  ifelse y > max-pycor
    [ set y max-pycor ]
    [ if y < (min-pycor + 1)
      [ set y (min-pycor + 1) ] ]
  setxy x y
end

to drag-and-drop-nodes
    ifelse mouse-down? 
    [ ifelse is-agent? clicked-node 
        [ ask clicked-node [ setxy mouse-xcor mouse-ycor ] ]
        [   ;; no buyer had been clicked
            ;; if there are nodes at the current mouse location, then pick one
          if any? nodes-at mouse-xcor mouse-ycor [  
            set clicked-node one-of nodes-at mouse-xcor mouse-ycor
          ]
        ]
      ask edges [ reposition-edge ] 
    ]
    [   ;; mouse not down
      set clicked-node nobody
    ]    
    
end

;; The algorithm for the following procedure has been borrowed from the 
;; model "Preferential Attachment", in the "Models library".
;; The copyright for this procedure is included at the bottom of this file

  ;; resize-nodes, change back and forth from size based on degree to a size of 1
to resize-nodes
  ifelse ( not (any? nodes with [size > 1]) )
  [ ask nodes [ set size sqrt length edgeees] ]
  [ ask nodes [ set size 1 ] ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Genetic Algorithms Procedures ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




to-report compute-factorial [x]
let n 1
let factorial 0
 repeat (x - 1)
  [set factorial factorial + n
   set n n + 1
   ]
 report factorial
end                                                                                                                                                                                                   

to create-genome

;; here is where I must create a random binary string for each node and it must have a zero in 
;; position corresponding to the node because there's no loop condition (no self-connection).
 
 ask nodes [
 set genome []
 set genome n-values num-nodes [0]]
 
 ;; crea el genoma basico de grafo no dirigido (matriz triangular superior)
 set basic-genome []
 set basic-genome n-values compute-factorial num-nodes  [random 2]
 
 ;; Ahora, copia esos datos y se lo inserta en los genomas de los nodos respectivos (la diagonal principal nunca es usada)
 let y 0
 let g 1
  while [y < (num-nodes - 1)] ;; recorro todos los nodos menos el _ltimo
   [set g y + 1
    while [g < num-nodes] ;; de cada nodo, tengo que llegar al final del genome
     [ask node y [set genome replace-item g genome item y basic-genome] 
      set g g + 1
      ] 
      set y y + 1
     ]
     
;; se completa la diagonal inferior para todos los nodos, simetrica a la superior
let i 0
let j 0

   while [i < num-nodes ][set j 0
     while [j < num-nodes ][
      if [item j genome] of node i = 1
        [ask node j [set genome replace-item i genome 1]
         ]
      set j j + 1]
   set i i + 1]

;show basic-genome
;let a 0
;while [a < num-nodes]
;   [ask node a [show genome]
;    set a a + 1 ]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to warshall 
set sum-links 0
;; It creates the reachability-matrix by adding individual's node genome
 set adjacency-matrix []
 set transitive-matrix []

;; this is the adjancency matrix
 let p 0
    while [p < num-nodes]
     [set adjacency-matrix lput [genome] of node p adjacency-matrix 
      set sum-links sum-links + sum [genome] of node p
      set p p + 1]
   
;diag-zero adjacency-matrix      

 ;;; Warshall's algorithm
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 let i 0
 let j 0
 let k 0

;; Get a copy of the transitive closure matrix
set transitive-matrix adjacency-matrix 
let track 1
 while [i < num-nodes] 
    [ set j 0
     while [j < num-nodes]
      [if (item j item i transitive-matrix = 1)
        [set k 0 set track 1
         while [k < num-nodes]
          [ if (item j item k transitive-matrix = 1)
           [set transitive-matrix (replace-item i transitive-matrix (
            replace-item k (item i transitive-matrix) track ))]
            set track track + 1
           set k k + 1]]
       set j j + 1]
    set i i + 1]
;show (word transitive-matrix "a")
;; Finally we got the transitive closure matrix for the original adjacency-matrix 

end


to indirect-information-matrix

let prev-indirect-info n-values num-nodes [n-values num-nodes [0]] ;; a matrix of num-nodes of zeroes is created
ask nodes [set indirect-info []]
  let r 0
  let s 0

while [r < num-nodes]
   [set s 0
    while [s < num-nodes]
        [ 
         set prev-indirect-info (replace-item r prev-indirect-info
                    (replace-item s (item r prev-indirect-info) 
                    (item s item r transitive-matrix - item s item r adjacency-matrix))) ;; acabo de agregar valor absoluto
         set s s + 1]
        set r r + 1]

let i 0
 while [i < num-nodes]
       [ ask node i [set indirect-info item i prev-indirect-info]
          set i i + 1 ]       

   
end


to update-transitive-matrix
;; Back transformation, return reachability-matrix to reachability-matrix in the original
;; format of genome 
set transitive-matrix []
let p 0
    while [p < num-nodes]
     [
       set transitive-matrix lput [indirect-info] of node p transitive-matrix  
       set p p + 1
     ]

;show (word transitive-matrix "b")
end

to sort-global-fitness
set topology-list remove-duplicates topology-list
set topology-list sort-by [ item compute-factorial num-nodes ?1 > item compute-factorial num-nodes ?2] topology-list

end

to mate-recombine

;let scd compute-factorial num-nodes / 2

set best-fitness item compute-factorial num-nodes item 0 topology-list 
set avg-fitness smoothness * avg-fitness + (1 - smoothness) * best-fitness 

;; Ac_ tengo que elegir entre cual configuraci_n, provista por genome, me da mayor pago, provista por fitness, y seleccionar la mejor. 
;; tengo entonces que ver como formo la matriz de adyacencia de la que deriva la formaci_n original y la nueva que se utilizar_
;; con el algoritmo gen_tico.



    if Selection = "Elitism"  [elitism
                               set seed-genomes item 0 winner-list]
    if Selection = "Roulette" [wheel-roulette
                              let chosen-generation item random-float length ranking ranking
                              let chosen-topology position chosen-generation ranking 
                              set seed-genomes item chosen-topology topology-list ]
    if Selection = "Tournament" [tournament
                              set seed-genomes item 0 winner-list]


 ; will only allow mating between chosen ones of previous generation (not their offspring)
  
  
  make-mix-genes                               ;recombine genomes of those who mate
  let o 0 
  
  while [o < (compute-factorial num-nodes)]
  [
   set seed-genomes (replace-item o mix-genes item o seed-genomes)
   set o o + 1
  ]
end

to wheel-roulette
let i 0
set sum-fitness 0
set ranking []

while [i < min (list (generations * .01) length topology-list) ]
  [
  set sum-fitness sum-fitness + item compute-factorial num-nodes item i topology-list 
  set i i + 1
  ]
set i 0  
while [i < min (list (generations * .01) length topology-list) ]
  [
  set ranking lput ((item compute-factorial num-nodes item i topology-list) / sum-fitness) ranking 
  set i i + 1
  ]
  
end 

to tournament

let draftlist topology-list
set winner-list []
set draftlist shuffle topology-list
set winner-list n-of (1 + random(length draftlist / 2)) draftlist

set winner-list sort-by [ item (compute-factorial num-nodes) ?1 > item (compute-factorial num-nodes) ?2] winner-list 
  
end

to elitism

let draftlist topology-list
set winner-list []
set winner-list sublist draftlist 0 (1 + random (length draftlist - 1))

end

to driven-theory

set empty-topology n-values compute-factorial num-nodes [0]
set complete-topology n-values compute-factorial num-nodes [1]
;set complete-topology diag-zero complete-topology 
 
end


to make-mix-genes
;; trabajan con seed-genomes, toman un _tem al azar y crean el marido. Igualan a la esposa con el marido
;; si el item 0 de seed-genomes = item 1 de seed-genomes no pasa nada, pero si no son iguales entonces
;; igualo ambos 
 let k 0
 let i random compute-factorial ( num-nodes - 1)
 let v compute-factorial num-nodes - i
 
 
  set mix-genes []
  let husband []
  let wife []
  
  let chosen random-float 1
  let swap false
    while [k < i][
     ifelse chosen < .5 [ set swap true
     if Selection = "Elitism"  [ set husband lput item k seed-genomes husband]
     if Selection = "Roulette" [ set husband lput item k seed-genomes husband]
     if Selection = "Tournament" [ set husband lput item k item 0 winner-list husband] ]
     [
      if Selection = "Elitism"  [set wife lput item k seed-genomes wife]
      if Selection = "Roulette" [set wife lput item k seed-genomes wife] 
      if Selection = "Tournament" [set wife lput item k item 0 winner-list wife] 
     ]
      ;assigns random genome to husband
     set k k + 1
     ]
;; consultar este procedimiento con Ignacio: el esposo es mitad del item k de seed-genomes en elitism...?
  while [k < v][
  ifelse swap = true [
  ;set wife lput item k item random generation topology-list wife
    if Selection = "Elitism"  [set wife lput item k item random length winner-list winner-list wife]
    if Selection = "Roulette" [set wife lput item k item random length topology-list topology-list wife] 
    if Selection = "Tournament" [set wife lput item k item 0 winner-list wife] ]
    [
     if Selection = "Elitism"  [set husband lput item k item random length winner-list winner-list husband]
     if Selection = "Roulette" [set husband lput item k item random length topology-list topology-list husband]
     if Selection = "Tournament" [set husband lput item k item 0 winner-list husband] 
    ]
   ;other half goes to wife
  set k k + 1
  ]
  
   while [k < compute-factorial num-nodes][
     ;ifelse chosen < .5 [ set swap true
   
   ifelse swap = true [
     if Selection = "Elitism"  [ set husband lput item k seed-genomes husband]
     if Selection = "Roulette" [ set husband lput item k seed-genomes husband]
     if Selection = "Tournament" [ set husband lput item k item 0 winner-list husband] ]
     [
      if Selection = "Elitism"  [set wife lput item k seed-genomes wife]
      if Selection = "Roulette" [set wife lput item k seed-genomes wife] 
      if Selection = "Tournament" [set wife lput item k item 0 winner-list wife] 
     ]
      ;assigns random genome to husband
     set k k + 1
     ]
   

let wh []
set wh lput wife wh
set wh lput husband wh
let mix-previous reduce [sentence ?1 ?2] wh 
set mix-genes reduce [sentence ?1 ?2] mix-previous


end

to mutate
;; Here is where a mask covering the zeroes in diagonal must be added.    

   let genome-m 0
       while [genome-m < length seed-genomes] [ ; scan all genes
           if (random-float 1000 < mutation-rate * 1000)  
           ; change bit if mutation rate threshold is met
           [ let switch item genome-m seed-genomes
           ifelse (switch = 1)
           [ set seed-genomes (replace-item genome-m seed-genomes 0 ) ]
           [ set seed-genomes (replace-item genome-m seed-genomes 1 ) ]
           ]
   set genome-m genome-m + 1 ; moves to next genome
    ] 
;set seed-genomes diag-zero seed-genomes

end

to rebirth
   
   ask patches [set pcolor black - .15]
   set-default-shape edges "line"
   create-genetic-info
   sort-global-fitness
   if length topology-list > 50 [set topology-list butlast topology-list]
   set topology-list remove-duplicates topology-list
   build-ga-network item 0 topology-list
      
end

to update-genome 
 
 ask nodes [set genome n-values num-nodes [0] ]
; show seed-genomes
 ;; Ahora, copia esos datos y se lo inserta en los genomas de los nodos respectivos (la diagonal principal nunca es usada)
  
  let j 0
  let q 0
  while [j < (num-nodes - 1)][ let i j + 1
   while [i < num-nodes]
    [ask node j [set genome (replace-item i genome item q seed-genomes)]
       set q q + 1
       set i i + 1 ]
     set j j + 1]
    

;; se completa la diagonal inferior para todos los nodos, simetrica a la superior
let i 0
set j 0

   while [i < num-nodes ][set j 0
     while [j < num-nodes ][
      if [item j genome] of node i = 1
        [ask node j [set genome replace-item i genome 1]
         ]
      set j j + 1]
   set i i + 1]

;let a 0
;while [a < num-nodes]
;   [ask node a [show genome]
;    set a a + 1 ]
; 
   
end

to theory-driven
if theory-driven? [driven-theory
let chosen random-float 1
ifelse chosen < .5 [
  set seed-genomes empty-topology]
 [set seed-genomes complete-topology  ]
 
 set theory-driven? false]

end


;to-report diag-zero [matrix]
;;; zero diagonal mask  
;;; esta mal, hace cualquier cosa...
; ;let s matrix
; ;let p length s
; ;show s
; let i 1
; let j num-nodes
; while [j < (num-nodes * num-nodes)]
;       [ set matrix  replace-item (i + j) matrix  0
;         set i i + 1
;         set j j + num-nodes
;        ]   
; set matrix  replace-item 0 matrix  0        
; set matrix  replace-item (num-nodes * num-nodes - 1) matrix  0  
; ;show s
; report matrix 
;end

;;;;;;;;;;;;;;;;;;;;;
;;; Export Outcomes ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;

to export
let i 0
file-delete "GA_1.txt"
file-open "GA_1.txt"

while [i < num-nodes][
  ask node i [print (word "node "  i  " " genome)]
  set i i + 1 ]

export-output "GA_1.txt"
file-close 
export-view (word edge-Cost-Structure "-" generations "-"  "-" ".png") 
export-plot "Accessibility Distribution" "Access.csv"





end
@#$#@#$#@
GRAPHICS-WINDOW
292
12
596
337
10
10
14.0
1
10
1
1
1
0
1
1
1
-10
10
-10
10
0
0
1
ticks
30.0

BUTTON
15
11
81
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
187
10
248
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
104
10
164
43
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
601
92
688
125
relax network
layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
60
109
93
num-nodes
num-nodes
3
100
10
1
1
NIL
HORIZONTAL

SWITCH
600
11
764
44
show-network-evolution
show-network-evolution
0
1
-1000

PLOT
601
127
785
247
Accessibility Distribution
# of reachable nodes
# of nodes
0.0
2.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 false "" ""

CHOOSER
6
168
115
213
accessibility-steps
accessibility-steps
1 2 3 4 5 10 20 "Infinity"
0

BUTTON
792
211
901
244
Update accessibility
plot-accessibility\\nplot-direct-profits\\nplot-indirect-profits
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
6
95
110
128
generations
generations
0
20000
15000
1
1
NIL
HORIZONTAL

SLIDER
6
132
112
165
mutation-rate
mutation-rate
0
0.5
0.01
0.01
1
NIL
HORIZONTAL

BUTTON
689
92
782
125
Drag and drop
drag-and-drop-nodes
T
1
T
TURTLE
NIL
NIL
NIL
NIL
1

PLOT
602
250
762
370
Direct Benefits
generations
net direct profits
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"net-direct-benefits" 1.0 0 -13791810 false "" ""
"avg-dir" 1.0 2 -10899396 true "" ""

MONITOR
117
52
194
97
generation
 (generation / (generations + 1)) * 100 
2
1
11

SLIDER
7
216
124
249
ratio-info-edge
ratio-info-edge
0.01
10
0.12
0.01
1
NIL
HORIZONTAL

PLOT
765
250
925
370
Indirect Benefits
generations
Indir. Profits
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"net-indirect-benefits" 1.0 0 -7500403 false "" ""
"avg-ind" 1.0 2 -16777216 true "" ""

PLOT
128
103
288
223
Best-Average-Profit
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Moving-Average" 1.0 2 -13345367 false "" ""
"Best" 1.0 0 -2674135 true "" ""

CHOOSER
7
333
118
378
Selection
Selection
"Roulette" "Elitism" "Tournament"
2

CHOOSER
600
46
765
91
edge-Cost-Structure
edge-Cost-Structure
"direct cost direct info" "direct cost indirect info" "indirect cost direct info" "indirect cost indirect info"
1

BUTTON
792
175
865
208
Update
plot-accessibility
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
7
251
125
296
information-endowment
information-endowment
"deterministic" "random" "heterogeneous"
0

SLIDER
7
298
125
331
value-of-info
value-of-info
0
3
1
0.1
1
NIL
HORIZONTAL

MONITOR
198
52
285
97
Best F
best-fitness
1
1
11

MONITOR
295
342
598
387
fitlist
fitlist
17
1
11

MONITOR
12
391
1061
436
NIL
item 0 topology-list
17
1
11

SLIDER
788
17
821
167
smoothness
smoothness
0
1
0.941
.001
1
NIL
VERTICAL

SWITCH
138
234
276
267
theory-driven?
theory-driven?
1
1
-1000

SLIDER
824
19
857
169
rate-of-decay
rate-of-decay
0
1
0.5
.1
1
NIL
VERTICAL

SWITCH
138
268
241
301
decay
decay
1
1
-1000

PLOT
866
17
1066
167
Network Density
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"density" 1.0 0 -6459832 true "" ""

SWITCH
139
305
242
338
B&W
B&W
1
1
-1000

TEXTBOX
896
176
1046
204
Two-Way Model\\nUndirected Graph
11
0.0
1

MONITOR
938
227
1007
272
D1
rate-of-decay - (rate-of-decay ^ 2)
3
1
11

MONITOR
939
282
1007
327
D2
rate-of-decay + (((num-nodes - 2) / 2) * rate-of-decay ^ 2)
3
1
11

MONITOR
1020
228
1077
273
gC
value-of-info / (rate-of-decay - (rate-of-decay ^ 2))
3
1
11

MONITOR
1021
282
1078
327
gE
value-of-info / (rate-of-decay + (((num-nodes - 2) / 2) * rate-of-decay ^ 2))
3
1
11

@#$#@#$#@

## WHAT IS IT?

NFGA (Network Formation Games with Accumulative-Costs) is a model designed to study the effects of accumulative costs in network formation games. The main assumption is that agents simultaneously choose who to connect with first and when agents connect to each others they have to pay no only for the directed but also for undirected connections. 

This model is based on network formation games among firms in oligopolic markets. Firms essays on each round a connection with other firms. This is a two-way (non-directed) network.

## QUICK GUIDE

You should try to prove different configurations of link-costs and information costs.  
Other modifications include mutation rate (usually greater than 0.01 gives trembling results), change the slide of the number of generations (for observing convergence in the algorithm), selection procedure (elitism selects best genomes, roulette selects random genomes). 

## HOW IT WORKS

Social network

Agents can be connected, forming a social network. Thus, each node may link to none, one, or several nodes; this (potentially empty) set of neighbours defines the node's social neighbourhood.   

The model tries to replicates theoretical results according to Goyal and Joshi (2002) but using an evolutive algorithm that takes samples of the network and then by mating and recombining, mutating and rebirth new populations evolve to achieved an optimal network architecture.


## HOW TO USE IT 

First, press SETUP button and the GO button. You will see how the genetic algorithm works by randomly selecting an adjacency matrix that represent links between agents. Structure will evolve by agents modifying in their decisions of connecting people. The importance is to play atention to the final topology that emerges in the last periods of the simulation. These would be the evolving outcomes of these connection games.

## THINGS TO TRY

Try by modifying, first of all, the values of value-of-info and link-cost. If you know a little bit of genetic algorithm, try by selecting Elitism and Roulette Wheel in selection of mating peers.

## CREDITS

Juan M.C. Larrosa, Master Thesis in Scientific Computing, Universidad Nacional del Sur, 2006  
Ignacio Ponzoni, Thesis Director, Universidad Nacional del Sur  
Fernando Tohm_, Thesis Co-Director, Universidad Nacional del Sur.

## REFERENCES

Goyal, S and S Joshi (2002). "Networks of Collaboration in Oligopolies". 
http://merlin.fae.ua.es/fvega/Course/Art%EDculos%20del%20curso/Goyal-Joshi.pdf

Wilensky U (1999) NetLogo. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

clocks
true
4
Circle -1184463 true true 0 0 300
Circle -1 true false 30 30 240
Rectangle -1184463 true true 135 45 165 150

coloured line
true
0
Line -11221820 false 150 300 150 225
Line -13791810 false 150 225 150 150
Line -13345367 false 150 150 150 75
Line -8630108 false 150 75 150 0

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person business
false
0
Rectangle -1 true false 120 90 180 180
Polygon -13345367 true false 135 90 150 105 135 180 150 195 165 180 150 105 165 90
Polygon -7500403 true true 120 90 105 90 60 195 90 210 116 154 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 183 153 210 210 240 195 195 90 180 90 150 165
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 76 172 91
Line -16777216 false 172 90 161 94
Line -16777216 false 128 90 139 94
Polygon -13345367 true false 195 225 195 300 270 270 270 195
Rectangle -13791810 true false 180 225 195 300
Polygon -14835848 true false 180 226 195 226 270 196 255 196
Polygon -13345367 true false 209 202 209 216 244 202 243 188
Line -16777216 false 180 90 150 165
Line -16777216 false 120 90 150 165

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="10TWfullefficient" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>export-view (word "TW-" information-endowment "-" Selection " " edge-Cost-Structure "-" num-nodes "-" ratio-info-edge "-" mutation-rate "-" random 3000 ".png")</final>
    <exitCondition>density = 0 or density = 1</exitCondition>
    <metric>density</metric>
    <metric>profits</metric>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="0.1"/>
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="information-endowment">
      <value value="&quot;deterministic&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;direct cost direct info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.35"/>
      <value value="2"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
      <value value="&quot;Elitism&quot;"/>
      <value value="&quot;Roulette&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="10000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="B&amp;W">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="twindirecostindireinfo10decay" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>export-view (word "TW" "-" Selection " " edge-Cost-Structure "-" num-nodes "-" ratio-info-edge "-" mutation-rate "-" rate-of-decay "-" random 1000 ".png")</final>
    <metric>density</metric>
    <metric>profits</metric>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;indirect cost indirect info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.1"/>
      <value value="1"/>
      <value value="1.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
      <value value="&quot;Roulette&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="B&amp;W">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rate-of-decay">
      <value value="0.1"/>
      <value value="0.5"/>
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="twindirecostindireinfo20decay" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>export-view (word "decay-" rate-of-decay "-TW" "-" Selection " " edge-Cost-Structure "-" num-nodes "-" ratio-info-edge "-" mutation-rate "-" random 1000 ".png")</final>
    <metric>density</metric>
    <metric>profits</metric>
    <enumeratedValueSet variable="num-nodes">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;indirect cost indirect info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.1"/>
      <value value="1"/>
      <value value="1.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
      <value value="&quot;Roulette&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="B&amp;W">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rate-of-decay">
      <value value="0.1"/>
      <value value="0.5"/>
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="5TWfullefficient2" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>export-view (word "TW-" num-nodes "-" Selection " " edge-Cost-Structure "-" ratio-info-edge "-" mutation-rate "-" random 3000 ".png")</final>
    <exitCondition>density = 0 or density = 1</exitCondition>
    <metric>density</metric>
    <metric>profits</metric>
    <enumeratedValueSet variable="num-nodes">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="information-endowment">
      <value value="&quot;deterministic&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;direct cost direct info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.35"/>
      <value value="2.5"/>
      <value value="9"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
      <value value="&quot;Elitism&quot;"/>
      <value value="&quot;Roulette&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="10000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="B&amp;W">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="B&amp;W">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accessibility-steps">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;direct cost indirect info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0.01"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="theory-driven?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="smoothness">
      <value value="0.941"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="information-endowment">
      <value value="&quot;deterministic&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rate-of-decay">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="value-of-info">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="15000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="BalaGoyal" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>export-view (word "TW-" num-nodes "-" Selection " " edge-Cost-Structure "-" ratio-info-edge "-" mutation-rate "-" random 3000 ".png")</final>
    <exitCondition>density = 0 or density = 1</exitCondition>
    <metric>density</metric>
    <metric>profits</metric>
    <enumeratedValueSet variable="num-nodes">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-network-evolution">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="information-endowment">
      <value value="&quot;deterministic&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="edge-Cost-Structure">
      <value value="&quot;direct cost direct info&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ratio-info-edge">
      <value value="0.35"/>
      <value value="2.5"/>
      <value value="9"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Selection">
      <value value="&quot;Tournament&quot;"/>
      <value value="&quot;Elitism&quot;"/>
      <value value="&quot;Roulette&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="generations">
      <value value="10000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="B&amp;W">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="decay">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
