breed [people person]
breed [mosquitoes mosquito]
people-own [energy infection kids IT]
mosquitoes-own [menergy minfection mids MIT]
globals [number-died]

to setup
  clear-all
  ask patches [ set pcolor green ]
  set-default-shape people "person"
  set number-died 0
  create-people initial-number-of-people
  [
    set color blue
    set size 2
    set kids 0
    set label-color blue - 2
    set energy random-float 50
    setxy random-xcor random-ycor
  ]
  set-default-shape mosquitoes "bug"
  create-mosquitoes initial-number-potentials
  [
    set color black
    set size 1
    set menergy random-float 50
    setxy random-xcor random-ycor
  ]
  create-mosquitoes initial-number-vectors
  [
    set minfection 1
    set color red
    set size 1
    set menergy random-float 50
    setxy random-xcor random-ycor
  ]
  reset-ticks
end

to go
    ask people [
    reproduce-people
    move-people
    catch-mosquitoes
    death-people
    color-infection
  ]
  ask mosquitoes [
    reproduce-mosquitoes
    move-mosquitoes
    catch-people
    death-mosquitoes
    color-minfection
  ]
  add-mosq
  kill-mosq
  if count people < 1 [
    stop]
  if ticks >= 2000 [
    stop]
  tick
end

to move-people
rt random 50
lt random 50
if infection = 0 [
    set energy energy + random-float 3]
if infection = 1 [
    set energy energy + random-float 1
    if IT > 0 [set IT IT - 1]
    if IT = 0 [set color blue set infection 0]
  ]
fd people-movement / 50
set energy energy - random-float 1.5
end

to move-mosquitoes
  rt random 50
  lt random 50
  set menergy menergy - random-float 1
  if minfection = 1 [set MIT MIT - 1]
  fd (temperature / 5)
end

to catch-people
  let prey one-of people-here
  if prey != nobody [set menergy menergy + random-float 50]
if minfection = 1 [
  if prey != nobody
    [ ask prey [ set infection  1 set IT 10]
    ]
]
end

to catch-mosquitoes
  let mosq one-of mosquitoes-here
if infection = 1 [
  if mosq != nobody
    [ ask mosq [ set minfection 1 set MIT 5]
    ]
]
end

to reproduce-people
   if count people < 100 [
    if energy >= 199
    [
    set kids random number-children
    hatch kids [rt random-float 360 fd 1 set energy random-float 5 set color blue]
    set energy random-float 50
    ]
  ]

end

to reproduce-mosquitoes
     if count mosquitoes < 500 [
  if menergy >= 199
    [
    ;;set mids 10
    hatch 20 [rt random-float 360 fd 1 set menergy random-float 5 set color black]
    die
  ]
  ]
end

to death-people
  ask people [
    if energy < 0 [
      set number-died (number-died + 1)
      die]
  ]
end

to death-mosquitoes
  ask mosquitoes [
    if menergy < 0 [die]]

end

to color-infection
if infection = 1 [
  set color red
]
end

to color-minfection
if minfection = 1 [
  set color red
]
end

to add-mosq
  let monte random-float 1
  if monte <= vector-migration [
    create-mosquitoes 1 [
      set menergy random-float 5
      let mm random-float 1
      ifelse mm <= 0.99 [
      set minfection 1
        set color red][
      set minfection 0
      set color blue]

    ]
  ]
end

to kill-mosq
  if count people with [color = red] / count people >= control-population [
    ask mosquitoes [die]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
208
10
647
450
-1
-1
13.121212121212123
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

SLIDER
11
78
199
111
initial-number-of-people
initial-number-of-people
1
50
20.0
1
1
NIL
HORIZONTAL

SLIDER
11
122
199
155
initial-number-potentials
initial-number-potentials
1
200
75.0
1
1
NIL
HORIZONTAL

SLIDER
11
165
201
198
initial-number-vectors
initial-number-vectors
0
200
2.0
1
1
NIL
HORIZONTAL

SLIDER
12
211
201
244
temperature
temperature
1
10
1.0
1
1
NIL
HORIZONTAL

BUTTON
23
22
86
55
NIL
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
96
22
159
55
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
650
10
1027
203
Human Population Graph
ticks
population
0.0
2000.0
0.0
105.0
false
true
"" ""
PENS
"Uninfected" 1.0 1 -14070903 true "" "plot count people with [color = blue]"
"Infected" 1.0 1 -2674135 true "" "plot count people with [color = red]"
"Total People" 1.0 2 -16777216 true "" "plot count people"

SLIDER
12
256
202
289
people-movement
people-movement
0
100
5.0
1
1
NIL
HORIZONTAL

SLIDER
11
298
203
331
number-children
number-children
0
10
2.0
1
1
NIL
HORIZONTAL

PLOT
650
203
1027
380
Mosquito Population Graph
ticks
population
0.0
2000.0
0.0
505.0
false
true
"" ""
PENS
"Total" 1.0 0 -16777216 true "" "plot count mosquitoes"
"Vectors" 1.0 1 -2674135 true "" "plot count mosquitoes with [color = red]"
"Non-vectors" 1.0 1 -13345367 true "" "plot count mosquitoes with [color = black]"

SLIDER
11
338
204
371
vector-migration
vector-migration
0
0.1
0.02
0.001
1
NIL
HORIZONTAL

SLIDER
10
378
205
411
control-population
control-population
0
1.01
1.01
0.01
1
NIL
HORIZONTAL

PLOT
1034
10
1234
160
Human Deaths
ticks
NIL
0.0
2000.0
0.0
10.0
true
false
"" ""
PENS
"Humans Died" 1.0 0 -16777216 true "" "plot number-died"

MONITOR
1034
164
1191
209
Prop. of Humans Infected
count people with [color = red] / count people
2
1
11

MONITOR
1033
213
1191
258
Num Human Deaths
number-died
17
1
11

MONITOR
1033
263
1191
308
Num Humans
count people
17
1
11

MONITOR
1033
312
1191
357
Num Mosquitoes
count mosquitoes
17
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
