globals [ min-grade ]

breed [ students student ]
breed [ flags flag ]
breed [ arrows arrow ]

students-own
[
  user-id   
  step-size
  jail-timer
  turbo-timer
  my-goal
  seen-goal?
  my-arrows
]

arrows-own
[
  my-goal
]

patches-own 
[ 
  goal? 
  elevation
]

to startup
  setup
  hubnet-set-client-interface "COMPUTER" []
  hubnet-reset
end

to setup
  cp
  cd
  clear-output  
  
  set-default-shape flags "flag"
  set-default-shape arrows "arrow"
  set release-the-hounds? false

  ask flags [ die ]

  ask arrows [ die ]
 
  ask patches [ set goal? false ]
  
  ;; even out the colors in case somebody logged out
  let color-difference count students with [color = red] - count students with [color = blue]
  
  if color-difference > 1
  [
    ask n-of floor (color-difference / 2) turtles with [color = red] [ set color blue ]
  ]
  if color-difference < -1
  [
    ask n-of floor abs (color-difference / 2) turtles with [color = blue] [ set color red ]
  ]

  ask patches [ set elevation random-float 10 ]
  repeat 10 [ diffuse elevation 0.5 ]

  ask patches with [pycor > 0] [ set pcolor scale-color blue elevation 0 40 ]
  ask patches with [pycor < 0] [ set pcolor scale-color red elevation 0 40 ]    

  set min-grade min [ my-min-grade ] of patches
        
  ask one-of patches with [ pycor > max-pxcor - 10 ] 
  [ 
    sprout-flags 1 [ set color blue ht ] 
    set goal? true
    ask students with [color = blue ] [ set my-goal myself ]
  ]
  ask one-of patches with [ pycor < min-pxcor + 10 ] 
  [ 
    sprout-flags 1 [ set color red ht ] 
    set goal? true
    ask students with [color = red ] [ set my-goal myself ]
  ]

  ask students
  [
    hubnet-clear-overrides user-id
    set step-size default-step-size
    set jail-timer 0
    set turbo-timer 0
    move-to one-of patches with [shade-of? pcolor [color] of myself]
    hubnet-send-follow user-id self vision
    hubnet-send-override user-id flags "hidden?" [false]
    hubnet-send-override user-id self "shape" ["default halo"]
    set heading one-of [0 90 180 270]
    set seen-goal? false
    create-arrow self my-goal color    
  ]
end

to create-arrow [root g c]
  set my-arrows no-turtles
  hatch-arrows 1
  [
    ht
    set my-goal g
    set color c
    move-arrow
    hubnet-send-override [user-id] of myself self "hidden?" [ false ]
    ask root [ set my-arrows (turtle-set my-arrows myself) ]
  ]  
end

to move-arrow
  move-to myself
  face my-goal
  fd distance my-goal * 9 / world-width
end

to-report my-min-grade
  report min [ elevation - [elevation] of myself ] of neighbors4
end

;;
;; Runtime Procedures
;;

to go
  every speed
  [
    listen-clients
    display
    ask students 
    [ 
      set jail-timer jail-timer - 1 
      if jail-timer > 0
      [ hubnet-send-override user-id self "label" [jail-timer] ]
      if jail-timer = 0 
      [ hubnet-clear-override user-id self "label"]
      if turbo-timer > 0
      [ 
        set turbo-timer turbo-timer - step-size 
        if turbo-timer <= 0
        [ 
          set jail-timer round ( turbo-length * turbo-rest-fraction / step-size )
          set step-size default-step-size
        ]
      ]
      
      if jail-timer <= 0
      [ move ]
      ask my-arrows [ move-arrow ]
    ]
    if game-over?
    [ stop ]
  ]
end

to move
  if release-the-hounds?
  [
    let dist step-size + grade
    let next-patch patch-ahead dist
    if next-patch != nobody
    [
      if not any? link-neighbors and [distance [my-goal] of myself] of next-patch < puppy-guarding-radius  
      [ rt 180 ]
    ]
    fd dist
    tag
    grab-flag
    return-flag-to-base
    send-location
    
    if not seen-goal? 
    [ 
      let other-goal one-of patches in-radius 9 with [goal? and not shade-of? [color] of myself pcolor ]
      if other-goal != nobody
      [
        set seen-goal? true
        create-arrow self other-goal ifelse-value (color = red) [blue][red]
      ]
    ]
  ]
end

to-report grade
  let p patch-ahead 1
  if p = patch-here
  [ set p patch-ahead 1.5 ]
  if p = nobody
  [ report 0 ]
  report ([elevation] of p - elevation) * (step-size - min-step-size) / min-grade
end

to-report game-over?  
  let over? false
  ask students with [any? link-neighbors and goal? and shade-of? pcolor color]
  [
    user-message  (word user-id " has won the game for " ifelse-value (color = blue) ["blue"]["red"])
    set over? true
  ]
  report over?
end


;;
;; HubNet Procedures
;;

to listen-clients
  while [ hubnet-message-waiting? ]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ create-new-student ]
    [
      ifelse hubnet-exit-message?
      [ remove-student ]
      [ ask students with [user-id = hubnet-message-source]
        [ execute-command hubnet-message-tag ] 
      ]
    ]
  ]
end

to create-new-student
  create-students 1
  [
    set seen-goal? false
    set heading one-of [0 90 180 270]
    set user-id hubnet-message-source
    set step-size default-step-size
    set color ifelse-value (count students with [color = red] > count students with [color = blue])[blue][red]
    send-location
    move-to one-of patches with [shade-of? pcolor [color] of myself]
    hubnet-send-follow user-id self vision
    hubnet-send-override user-id flags "hidden?" [ false ]
    hubnet-send-override user-id self "shape" [ "default halo" ]
    set my-goal one-of patches with [goal? and shade-of? pcolor [color] of myself ]
    create-arrow self my-goal color
  ]
end

to remove-student
  ask students with [user-id = hubnet-message-source]
  [ 
    ask my-arrows [ die ]
    die 
  ]
end

to execute-command [command]
  if jail-timer > 0 or turbo-timer > 0
  [ stop ]
  if command = "right"
  [ rt 90 stop ]
  if command = "left"
  [ lt 90 stop ]
  if command = "turbo"
  [ 
    set turbo-timer turbo-length 
    set step-size (step-size * turbo-speed)
  ]
end

to send-location ;; student procedure
  hubnet-send user-id "location" (word "(" pxcor "," pycor ")")
end

to grab-flag ;; student procedure
  if not any? my-links
  [
    let my-flag one-of flags-here with [color != [color] of myself and not any? link-neighbors] 
    if my-flag != nobody
    [ 
      ask my-flag [ move-to myself ]
      create-link-with my-flag [ hide-link tie ]
      if goal?
      [
        let goal patch-here
        ask students
          [ hubnet-send-override user-id goal "pcolor" [pcolor + 4.5] ]
      ]
    ]
  ]
end

to return-flag-to-base
    let my-flag one-of flags-here with [color = [color] of myself and not any? link-neighbors] 
    if my-flag != nobody
    [
      ask my-flag [ move-to one-of patches with [goal? and shade-of? [color] of myself pcolor] ] 
    ]
end

to tag ;; student procedure
  if shade-of? pcolor color
  [
    let opponent one-of students-here with [color != [color] of myself]
    if opponent != nobody
    [
      ask opponent [ go-to-jail ]
      set jail-timer 20
    ]
  ]  
end

to go-to-jail ;; student procedure
  ask link-neighbors 
  [ 
    move-to one-of patches in-radius (puppy-guarding-radius + 1) with [distance [patch-here] of myself > puppy-guarding-radius]     
  ]
  ask my-links [ die ]
  move-to one-of patches with [pycor = 0]
  set jail-timer 100
  send-location
end
@#$#@#$#@
GRAPHICS-WINDOW
231
10
951
751
35
35
10.0
1
10
1
1
1
0
0
0
1
-35
35
-35
35
1
1
0
ticks

CC-WINDOW
5
765
960
860
Command Center
0

BUTTON
34
51
105
84
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
107
51
178
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
25
202
197
235
vision
vision
0
max-pxcor
9
1
1
NIL
HORIZONTAL

SLIDER
22
335
194
368
default-step-size
default-step-size
0.01
0.2
0.2
0.01
1
NIL
HORIZONTAL

SLIDER
24
168
196
201
speed
speed
0
1
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
25
236
197
269
puppy-guarding-radius
puppy-guarding-radius
0
10
3
0.1
1
NIL
HORIZONTAL

SWITCH
19
118
206
151
release-the-hounds?
release-the-hounds?
1
1
-1000

SLIDER
21
396
193
429
turbo-speed
turbo-speed
1
2
2
0.1
1
NIL
HORIZONTAL

SLIDER
21
301
194
334
min-step-size
min-step-size
0
0.1
0.01
0.01
1
NIL
HORIZONTAL

SLIDER
20
432
192
465
turbo-length
turbo-length
0
10
10
1
1
NIL
HORIZONTAL

SLIDER
19
467
193
500
turbo-rest-fraction
turbo-rest-fraction
0
1
1
0.1
1
NIL
HORIZONTAL

@#$#@#$#@
VERSION
-------
$Id: Capture the Flag.nlogo 40967 2008-09-09 19:44:01Z everreau $


@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

arrow 2
true
0
Line -7500403 true 150 0 135 15
Line -7500403 true 150 0 165 15
Line -7500403 true 150 0 150 300

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

default halo
true
0
Circle -1184463 false false 22 22 256
Polygon -7500403 true true 150 5 40 250 150 205 260 250

default outlined
true
0
Polygon -1184463 true false 150 0 30 255 150 205 270 255
Polygon -7500403 true true 60 225 150 30 240 225 150 180

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1pre5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
VIEW
252
10
962
720
0
0
0
1
1
1
1
1
0
1
1
1
-35
35
-35
35

BUTTON
113
76
176
109
right
NIL
NIL
1
T
OBSERVER
NIL
L

BUTTON
49
76
111
109
left
NIL
NIL
1
T
OBSERVER
NIL
J

MONITOR
70
21
157
70
location
NIL
0
1

BUTTON
79
111
145
144
turbo
NIL
NIL
1
T
OBSERVER
NIL
T

@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0

@#$#@#$#@
