breed               [ Banks        Bank      ]
breed               [ Firms        Firm      ]
breed               [ HouseHolds   Household ]
directed-link-breed [ Hireds       Hired     ]
directed-link-breed [ Owners       Owner     ]
breed               [ FirmEnergs   FirmEnerg ]

Globals [
  GDP
  LevelPrice
  levelPriceK
  LevelPriceE
  UnEmpRate
  CountK-Prod
  CountK-Cons
  CountProd
  CountCons
  v1
  v2
  v3
  v4
  betha01
  alpha01
  betha02
  alpha02
  EnergyProduce
]

Banks-own [
  Equity_Total
  Equity_K-Firms
  Equity_C-Firms
  Equity_Rentists
  Equity_Workers
  Equity_Loans
  Profit
  ]

Firms-own [
  K-Firms?
  Production
  Price
  Vacancy
  Demand
  N_workers
  Kapital
  Kapital_memory
  Investiment
  CapUtil
  DepositBank
  Production_t-1
  Profit
  ForeCastError
  CurrentIntRate
  LeverageRatio
  FinancialGap
  Loans
  ]

Households-own [
  Worker?
  HumanWealth
  ConsumeDesire
  DepositBank
  Own?
  Hired?
  Income
  ]

FirmEnergs-own [ 
  Demand
  Production
  Price
  ForeCastError
  ]

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> To Setup <<<<<<<<<<<<<<<<<<<<<<---------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to setup

  clear-all

  ;setup Globals                                                               *******************

  set GDP                  0
  set LevelPrice           InitialPrice
  set LevelPriceK          InitialPrice
  set UnEmpRate            1
  set CountK-Prod          0
  set CountK-Cons          0
  set CountProd            0
  set CountCons            0
  set v1 [ ] set v2 [ ] set v3 [ ] set v4 [ ]
  set betha01 0 set alpha01 0

  ;creating the Bank

  create-Banks 1 [
    setxy                 4.5 12.5
    set shape             "house"
    set size              1
    set color             yellow
    set Equity_Total      0
    set Equity_K-Firms    0
    set Equity_C-Firms    0
    set Equity_Rentists   0
    set Equity_Workers    0
    set Equity_Loans      InitialEquityBank
    set Profit            0
    ]

  ;generate firms and rentists                                                 *************

  let i 0

  while [ i < 10 ] [
    let j 0

    while [ j < 25 ] [

      ifelse i > 7 [

        ;create K-Firms type                                                 +++++++++++

        create-Firms 1 [
          setxy                 i j
          set shape             "house"
          set size              0.85
          set color             2
          set K-Firms?          true
          set Production        InitialProdK-Firms
          set CountK-Prod       CountK-Prod + Production
          set Price             InitialPrice
          set Vacancy           2
          set Demand            0
          set N_workers         0
          set Kapital           ""
          set Kapital_memory    ""
          set Investiment       0
          set CapUtil           ""
          set DepositBank       InitialLiquidity
          set Production_t-1    InitialProdK-Firms
          set CurrentIntRate    RiskFreeIntRate
          set LeverageRatio     0
          set Loans             0
          ]
        ] [

        ;create C-Firms type                                                 +++++++++++++

        create-Firms 1 [
          setxy                 i j
          set shape             "house"
          set size              0.85
          set color             4
          set K-Firms?          false
          set Production        InitialProdC-Firms
          set CountProd         CountProd + Production
          set Price             InitialPrice
          set Vacancy           2
          set Demand            0
          set N_workers         0
          set Kapital           K_initial
          set Kapital_memory    K_initial
          set Investiment       0
          set CapUtil           1
          set DepositBank       InitialLiquidity
          set Production_t-1    InitialProdC-Firms
          set CurrentIntRate    RiskFreeIntRate
          set LeverageRatio     0
          set Loans             0
          ]
        ]

        ;setup rentists as a owners of the firms                             +++++++++++++++++++++

        create-Households 1 [
          setxy                 i j
          set shape             "person"
          set size              0.65
          set color             white
          set Worker?           false
          set HumanWealth       1
          set ConsumeDesire     0
          set DepositBank       InitialHouseholdsAssets
          set Own?              true
          set Hired?            ""
          set Income            0
          create-Owner-from one-of Firms-here [ set hidden? true ] ;this link shows who is the firm's owner
          ]

      set j j + 1
      ]
    set i i + 1
    ]

  ;setup Workers                                                              ******************

  create-Households NumberWorkers [
    setxy                 random 10 random 25
    set shape             "person"
    set size              0.45
    set color             blue
    set Worker?           true
    set HumanWealth       1
    set ConsumeDesire     0
    set DepositBank       InitialHouseholdsAssets
    set Own?              ""
    set Hired?            false
    set Income            0
    ]

  ask Banks [
    set Equity_K-Firms   sum [DepositBank] of Firms      with [K-Firms?]
    set Equity_C-Firms   sum [DepositBank] of Firms      with [not K-Firms?]
    set Equity_Rentists  sum [DepositBank] of Households with [not Worker?]
    set Equity_Workers   sum [DepositBank] of Households with [Worker?]
    set Equity_Total     InitialEquityBank + Equity_K-Firms + Equity_C-Firms + Equity_Rentists + Equity_Workers
    ]
  
  create-FirmEnergs EnergiesCompanies [ 
    set shape       "flag"
    set size         1.5
    set color        white
    setxy random     10 random 25
    set Production   100
    set Demand       0
    set Price        InitialPrice
    ]

  reset-ticks
end

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> to Go  <<<<<<<<<<<<<<<<<<<<<<<<<<-------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________

to go

  jobMarket
  conMarket
  kapMarket
  bankManagement
  toProduce
  growPopulation
  EnergyMarket
  tick

end


;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> job market <<<<<<<<<<<<<<<<<<<<<<-------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to jobMarket

  ask Households with [Worker?] [

    if Hired?   = false [
      let i                0
      let Vacancy?         false

      while [ Hired? =     False    and     i < 5 ] [

        setxy              random 10     random 25

        ask one-of  Firms-here [
          if Vacancy   >     0 [
            set Vacancy?   true
            set Vacancy    Vacancy - 1
            set N_Workers  N_Workers + 1
            ]
          ]

        if Vacancy?        = true [
          set Hired?       true
          set Income       Wage
          create-Hired-to  one-of Firms-here [ set hidden? true ]  ;create a link betwen the worker and the Firm, this will end when the work is fired
          ]

        set i    i + 1
        ];end while
      ];end if Hired? = false
    ];end ask Workers

  set UnEmpRate (count Households with [Worker?] - count Hireds) / count Households with [Worker?]

end

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> Consume Market <<<<<<<<<<<<<<<<<<<<<<---------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to conMarket

  let Revenue        0
  let Consume        CountCons

  ask Households [

    set HumanWealth          HumWealthParam   *   HumanWealth     +  (1 - HumWealthParam) * Income
    set ConsumeDesire        HumanWealth    +  DepBankParam  *   DepositBank ; this means how the agent will want to consume
    let CsD                  ConsumeDesire
    let Who01                ""
    let Who02                ""
    let Pri01                ""
    let Pri02                ""
    let Pro01                ""
    let Pro02                ""
;now they will check two diffents firms and buy at the better, if it is not enoght at the first firm the agent try to buy at the second, if not he is forced to save
    setxy                    random 8 random 25
    ask one-of Firms-here [
      set Who01              Who
      set Pri01              Price
      set Pro01              CsD / Price
    ]

    setxy                    random 8 random 25
    ask one-of Firms-here [
      set Who02              Who
      set Pri02              Price
      set Pro02              CsD / Price
    ]

    while [ Who01 = Who02 ] [

      setxy                    random 8 random 25
      ask one-of Firms-here [
        set Who02              Who
        set Pri02              Price
        set Pro02              CsD / Price
        ]

      ];end While...

    ifelse Pri01 <= Pri02 [

      ask Firm Who01 [

        ifelse Production > CsD / Price [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + CsD / Price
          set DepositBank    DepositBank   + CsD
          set Csd            0
          set Production     Production    - Pro01

          ] [;secon part of ifelse Production > CsD / Price

          ifelse Production > 0 [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + Production
            set DepositBank    DepositBank   + Production * Price
            set Csd            CsD           - Production * Price
            set Production                   0

            ] [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + 0
          set DepositBank    DepositBank   + 0
          set Csd            CsD           - 0
          set Production                     0

            ];end ifelse Production > 0
          ];end ifelse Production > CsD / Price
        ];end ask Firm Who01

      if CsD > 0 [

      ask Firm Who02 [

        ifelse Production > CsD / Price [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + CsD / Price
          set DepositBank    DepositBank   + CsD
          set Production     Production    - CsD / Price
          set Csd                            0


          ] [;second part of ifelse Production > CsD / Price

          ifelse Production > 0 [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + Production
            set Consume      Consume           + Production
            set Csd            CsD           - Production * Price
            set Production                     0

            ] [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + 0
            set DepositBank    DepositBank   + 0
            set Csd            CsD           - 0
            set Production                     0

            ];end ifelse Production > 0
          ];end ifelse Production > CsD / Price
        ];end ask Firm Who02

        ];end If CsD > 0

      ] [;second part of ifelse Pri01 <= Pri02

      ask Firm Who02 [

        ifelse Production > CsD / Price [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + CsD / Price
          set DepositBank    DepositBank   + CsD
          set Production     Production    - CsD / Price
          set Csd                            0


          ] [;secon part of ifelse Production > CsD / Price

          ifelse Production > 0 [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + Production
            set DepositBank    DepositBank   + Production * Price
            set Csd            CsD           - Production * Price
            set Production                     0

            ] [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + 0
          set DepositBank    DepositBank   + 0
          set Csd            CsD           - 0
          set Production                     0

            ];end ifelse Production > 0
          ];end ifelse Production > CsD / Price
        ];end ask Firm Who02

      if CsD > 0 [

      ask Firm Who01 [

        ifelse Production > CsD / Price [

          set Demand         Demand        + CsD / Price
          set CountCons      CountCons     + CsD / Price
          set DepositBank    DepositBank   + CsD
          set Production     Production    - CsD / Price
          set Csd                            0

          ] [;secon part of ifelse Production > CsD / Price

          ifelse Production > 0 [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + Production
            set DepositBank    DepositBank   + Production * Price
            set Csd            CsD           - Production * Price
            set Production                     0

            ] [

            set Demand         Demand        + CsD / Price
            set CountCons      CountCons     + 0
            set DepositBank    DepositBank   + 0
            set Csd            CsD           - 0
            set Production                     0

            ];end ifelse Production > 0
          ];end ifelse Production > CsD / Price
        ];end ask Firm Who01

        ];end If CsD > 0**********************************************************

      ];end ifelse Pri01 <= Pri02

      ifelse    Worker?     [set DepositBank        DepositBank + Income - (ConsumeDesire - CsD)] [ set DepositBank        DepositBank - (ConsumeDesire - CsD) ]
      set       Revenue     Revenue   +  ConsumeDesire - CsD

    ];end ask households ////////////////////////////////////////////////////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  set Consume         CountCons  -  Consume
  set LevelPrice      Revenue    /  Consume



end

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> To Produce <<<<<<<<<<<<<<<<<<<<<<-------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to toProduce

  set GDP                    0

  ask Firms with [ not K-Firms? ] [

    ;energy situation
    let EnergyNeed N_Workers
    ask one-of FirmEnergs [ set Demand Demand + EnergyNeed ]
    ;end energy
    set Vacancy               0
    set Profit                max list         0 ((Production_t-1 - Production) * Price - N_Workers * Wage)
    set Production            min list         (N_Workers  * N_Prod) (Kapital * K_Prod)
    set GDP                   GDP              + Production
    set CountProd             CountProd        + Production
    set DepositBank           DepositBank      - (N_Workers * Wage) - (Profit * DividendPayoutRatio)

    ;...........now, how much will need to produce next period..........

    let DesireProduction      ""
    set ForeCastError         Demand           - Production_t-1

    ifelse  (ForeCastError >= 0  and Price >= LevelPrice) [

      set DesireProduction    Production_t-1   + QtdAdjParam * ForeCastError

    ] [

    ifelse (ForeCastError < 0 and Price < LevelPrice) [

      set DesireProduction    Production_t-1   + QtdAdjParam * ForeCastError

      ]

    [ set DesireProduction    Production_t-1 ]

      ];end desireproduction seting

    let MaxUtilKap            (Kapital         * K_prod) / N_Prod
    let Need_Workers          max list 0 (  min list (1 + int (DesireProduction / N_Prod))   (1 + int MaxUtilKap)  )

    ifelse Need_Workers <= N_Workers [ ; then the firm to fired some employee

      while [ (Need_Workers < N_Workers)  or N_Workers = 0] [

        ask one-of my-in-Hireds [
          ask other-end [
            set Hired?     false
            set Income     0
            ]
          die
          ]

        set N_Workers       N_Workers - 1
        ];end while...

      ] [;end first part of Need_workers <= N_Workers

      set Vacancy           Need_workers - N_Workers ;here the firm to hired, will open a vacancy and try to fill next period

      ];end ifelse Need_Workers...

    if ForeCastError   <=   0   and   Price >  LevelPrice  [ set Price    Price * (1 - random-float 1 * 0.10)]
    if ForeCastError   >    0   and   Price <= LevelPrice  [ set Price    Price * (1 + random-float 1 * 0.10)]

    set Demand               0
    set CapUtil              Production / (Kapital * K_Prod)
    set Production_t-1       Production


    ;Kapital depreciation end the Kapital Memory

    if ticks > 1            [ set Kapital_memory    (MemInv * Kapital_memory) + (1 - MemInv ) * Kapital ]
    set Kapital             Kapital * (1 - Depr * CapUtil)

  ];end ask C-Firms


; now produce at K-Firms........................................................................................................................................................

  ask Firms with [ K-Firms? ] [

    set Vacancy               0
    set Profit                max list           0 (Production_t-1 * Price)
    set GDP                   GDP                + N_Workers * N_Prod
    set CountK-Prod           CountK-Prod        + N_Workers * N_Prod
    set DepositBank           DepositBank        - (N_Workers * Wage) - (Profit * DividendPayoutRatio)

    let DesireProduction      ""
    set ForeCastError         Demand           - Production_t-1

    ifelse  (ForeCastError >= 0  and Price >= LevelPriceK) [

      set DesireProduction    max list 0 (Production_t-1   + QtdAdjParam * ForeCastError - Production)

    ] [

    ifelse (ForeCastError < 0 and Price < LevelPriceK) [

      set DesireProduction    max list 0 (Production_t-1   + QtdAdjParam * ForeCastError - Production)

      ]

    [ set DesireProduction    max list 0 (Production_t-1 - Production)]

      ];end desireproduction seting

    set Production            N_Workers  * N_Prod + (1 - Depr * 16) * Production
    set Production_t-1        N_Workers  * N_Prod
    let Need_Workers          1 + int (DesireProduction / N_Prod)
    if DesireProduction <= 0  [set Need_Workers 0]

    ifelse Need_Workers <= N_Workers [

      while [ Need_Workers < N_Workers ] [

        ask one-of my-in-Hireds [
          ask other-end [
            set Hired?     false
            set Income     0
            ]
          die
          ]

        set N_Workers       N_Workers - 1
        ];end while...

      ] [;end first part of Need_workers <= N_Workers

      set Vacancy           Need_workers - N_Workers

      ];end ifelse Need_Workers...

    if ForeCastError   <=     0   and   Price >    LevelPriceK  [ set Price    Price * (1 - random-float 1 * 0.10)]
    if ForeCastError   >      0   and   Price <=   LevelPricek  [ set Price    Price * (1 + random-float 1 * 0.10)]

    set Demand               0

    ];end ask K-Firms ............................................................................................


  ask Households with [ not Worker? ] [
    let Dividend            0
    ask one-of my-in-Owners [
      ask other-end [
        if Profit             > 0 [ set Dividend Profit * 0.20 ]
      ]
      ]
    set DepositBank           DepositBank + Dividend
    set Income                Dividend
    ]

end


;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> To kapMarket <<<<<<<<<<<<<<<<<<<<<<-----------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________



to kapMarket

  set CountK-Cons           0
  let Revenue               0

  ask Firms with [ not K-Firms?] [

    if random-float 1 < ProbInv [

    ;here lets think CsD as an Investiment Desire

    let CsD max list        0     ((((1 / DesCapUt) + (Depr / ProbInv)) * Kapital_memory) - (1 - CapUtil * Depr) * Kapital)
    let Debts               0
    let Who01               ""
    let Pri01               ""
    let Who02               ""
    let Pri02               ""
    let X                   xcor
    let Y                   ycor

;searching for the better price, the Consumer Firm will try to buy the Capital she needs at the better price

    setxy (random 2 + 8) random 25
    ask one-of other Firms-Here [
      set Who01             who
      set Pri01             Price
      ]

    setxy (random 2 + 8) random 25
    ask one-of other Firms-Here [
      set Who02             who
      set Pri02             Price
      ]

    while [Who01 = Who02] [

      setxy (random 2 + 8) random 25
      ask one-of other Firms-Here [
        set Who02             who
        set Pri02             Price
      ]

      ];end while who01 = who02

    let Pro01 max list        0 (DepositBank  / Pri01)
    let Pro02 max list        0 (DepositBank  / Pri02)
    set CsD   min (list       CsD Pro01 Pro02)
    set Investiment           CsD

    ifelse Pri01 <= Pri02 [

      ask Firm Who01 [

        ifelse Production >= CsD [

          set Demand          CsD * 1
          set CountK-Cons     CountK-Cons  + CsD
          set Revenue         Revenue      + CsD  * Price
          set DepositBank     DepositBank  + CsD  * Price
          set Debts           Debts        + CsD  * Price
          set Production      Production   - CsD
          set CsD             0

          ] [

          ifelse Production > 0 [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + Production
            set Revenue         Revenue      + Production  * Price
            set DepositBank     DepositBank  + Production  * Price
            set Debts           Debts        + Production  * Price
            set CsD             CsD          - Production
            set Production      0

            ] [

          set Demand          CsD * 1
          set CountK-Cons     CountK-Cons  + 0
          set Revenue         Revenue      + 0
          set DepositBank     DepositBank  + 0
          set Debts           Debts        + 0
          set Production      0
          set CsD             CsD

            ];end ifelse production > 0

          ];end ifelse Production >= CsD

        ];end ask Firm Who01

      if CsD > 0 [

        ask Firm Who02 [

          ifelse Production >= CsD [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + CsD
            set Revenue         Revenue      + CsD  * Price
            set DepositBank     DepositBank  + CsD  * Price
            set Debts           Debts        + CsD  * Price
            set Production      Production   - CsD
            set CsD             0

          ] [

          ifelse Production > 0 [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + Production
            set Revenue         Revenue      + Production  * Price
            set DepositBank     DepositBank  + Production  * Price
            set Debts           Debts        + Production  * Price
            set CsD             CsD          - Production
            set Production      0

          ] [

          set Demand          CsD * 1
          set CountK-Cons     CountK-Cons  + 0
          set Revenue         Revenue      + 0
          set DepositBank     DepositBank  + 0
          set Debts           Debts        + 0
          set Production      0
          set CsD             CsD

          ];end ifelse production > 0
          ];end ifelse Production >= CsD
        ];end ask Firm Who02
        ];end if CsD > 0

      ] [

      ask Firm Who02 [

        ifelse Production >= CsD [

          set Demand          CsD * 1
          ;set GDP             GDP          + CsD
          set CountK-Cons     CountK-Cons  + CsD
          set Revenue         Revenue      + CsD  * Price
          set DepositBank     DepositBank  + CsD  * Price
          set Debts           Debts        + CsD  * Price
          set Production      Production   - CsD
          set CsD             0

          ] [

          ifelse Production > 0 [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + Production
            set Revenue         Revenue      + Production  * Price
            set DepositBank     DepositBank  + Production  * Price
            set Debts           Debts        + Production  * Price
            set CsD             CsD          - Production
            set Production      0

            ] [

          set Demand          CsD * 1
          set CountK-Cons     CountK-Cons  + 0
          set Revenue         Revenue      + 0
          set DepositBank     DepositBank  + 0
          set Debts           Debts        + 0
          set Production      0
          set CsD             CsD

            ];end ifelse production > 0
          ];end ifelse Production >= CsD
        ];end ask Firm Who02

      if CsD > 0 [

        ask Firm Who01 [

          ifelse Production >= CsD [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + CsD
            set Revenue         Revenue      + CsD  * Price
            set DepositBank     DepositBank  + CsD  * Price
            set Debts           Debts        + CsD  * Price
            set Production      Production   - CsD
            set CsD             0

          ] [

          ifelse Production > 0 [

            set Demand          CsD * 1
            set CountK-Cons     CountK-Cons  + Production
            set Revenue         Revenue      + Production  * Price
            set DepositBank     DepositBank  + Production  * Price
            set Debts           Debts        + Production  * Price
            set CsD             CsD          - Production
            set Production      0

          ] [

          set Demand          CsD * 1
          set CountK-Cons     CountK-Cons  + 0
          set Revenue         Revenue      + 0
          set DepositBank     DepositBank  + 0
          set Debts           Debts        + 0
          set Production      0
          set CsD             CsD

          ];end ifelse production > 0
          ];end ifelse Production >= CsD
        ];end ask Firm Who01
        ];end if CsD > 0
      ];end ifelse Pri01 <= Pri02


    setxy X Y
    set Investiment           Investiment  - CsD
    set DepositBank           DepositBank  - Debts
    set Kapital               Kapital      + Investiment

    ];end ask C-Firms

  ];end if random < ProbInvs

  if Countk-Cons > 0 [ set LevelPriceK           Revenue      /   CountK-Cons ]

end ; to kapitalmarket

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------->>>>>>>>>>>>>>>> To BankManagement <<<<<<<<<<<<<<<<<<<<<<------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to bankManagement

  ask Firms with [not K-Firms?] [

    ifelse ticks < Tc [
      set v1 lput (DepositBank * LeverageRatio) v1
      ifelse DepositBank > 0 [ set v2 lput 1 v2 ] [ set v2 lput 0 v2 ]
    ] [
    set v1 lput LeverageRatio v1 set v1 remove-item 0 v1
    ifelse DepositBank > 0 [ set v2 lput 1 v2 ] [ set v2 lput 0 v2 ] set v2 remove-item 0 v2
    ]
    ];end ask C-firms

  ask Firms with [K-Firms?] [

    ifelse ticks < (Tc * 4) [
      set v3 lput (DepositBank * LeverageRatio) v3
      ifelse DepositBank > 0 [ set v4 lput 1 v4 ] [ set v4 lput 0 v4 ]
    ] [
    set v3 lput LeverageRatio v3 set v3 remove-item 0 v3
    ifelse DepositBank > 0 [ set v4 lput 1 v4 ] [ set v4 lput 0 v4 ] set v4 remove-item 0 v4
    ]
    ];end ask K-firms
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


    ask Banks [

      let Loans?    Equity_Loans
      let Profit?   Profit

      ask Firms [

        set DepositBank      DepositBank - Loans * CurrentIntRate - Loans * InstallmentDebt
        set Loans            Loans       - Loans * InstallmentDebt
        set Profit?          Profit?     + Loans * CurrentIntRate
        set Loans?           Loans?      + Loans * InstallmentDebt
        set FinancialGap     max list 0  ((Vacancy + N_workers) * Wage + Investiment * LevelPriceK - DepositBank)
        set LeverageRatio    (FinancialGap    + Loans)          / (abs DepositBank + FinancialGap + Loans)
        let AvalibleFunding  min list (max list 0 (Loans?  * BankLossParam)) FinancialGap

          if AvalibleFunding > 0 [
            let Numerator        1 + (RiskFreeIntRate / InstallmentDebt)
            let Denominator      (1 - (1 - InstallmentDebt) ^ (1 + LeverageRatio * 0.10)) / InstallmentDebt
            set CurrentIntRate   (BankMarkup      * ((Numerator / Denominator) - InstallmentDebt)) / 100
            set Loans?           Loans?          - AvalibleFunding
            set DepositBank      DepositBank     + AvalibleFunding
            set Loans            Loans           + AvalibleFunding
          ];end if avaliblefunding

        ;bankrupicies

        if DepositBank <= 0 [

          ifelse K-Firms? [

            set Loans?          Loans?       +  Loans
            set Profit?         Profit?      -  Loans
            let Debts?          DepositBank

            ask one-of my-out-Owners [ ask other-end [ set DepositBank  DepositBank + Debts? - InitialLiquidity ] ] ;capitalist recaptilyze the firm

            while [ N_Workers > 0 ] [

              ask one-of my-in-Hireds [
                ask other-end [
                  set Hired?         false
                  set Income         0
                ]
                die
              ]

              set N_workers N_workers - 1
            ];end while...

            set Production        InitialProdK-Firms
            set CountK-Prod       CountK-Prod + Production
            set Price             LevelPrice
            set Vacancy           2
            set Demand            0
            set N_workers         0
            set K-Firms?          true
            set Kapital           ""
            set Kapital_memory    ""
            set Investiment       0
            set CapUtil           ""
            set DepositBank       InitialLiquidity
            set Production_t-1    InitialProdK-Firms
            set Loans             0
            set FinancialGap      0
            set LeverageRatio     0
            set CurrentIntRate    RiskFreeIntRate

            ] [;C-Firms...

            set Loans?          Loans?     + Loans
            set Profit?         Profit?    - Loans
            let Debts?          DepositBank

            ask one-of my-out-Owners [ ask other-end [ set DepositBank  DepositBank + Debts? - InitialLiquidity ] ] ;capitalist recaptilyze the firm

            while [ N_Workers > 0 ] [

              ask one-of my-in-Hireds [
                ask other-end [
                  set Hired?         false
                  set Income         0
                ]
                die
              ]

              set N_workers N_workers - 1
            ];end while...

            set Production        InitialProdC-Firms
            set CountProd         CountProd + Production
            set Price             LevelPrice
            set Vacancy           2
            set Demand            0
            set N_workers         0
            set K-Firms?          false
            set Kapital           K_initial
            set Kapital_memory    K_initial
            set Investiment       0
            set CapUtil           1
            set DepositBank       InitialLiquidity
            set Production_t-1    InitialProdC-Firms
            set Loans             0
            set FinancialGap      0
            set LeverageRatio     0
            set CurrentIntRate    RiskFreeIntRate

            ];end ifelse K-Firms?
          ];end if depositbank < 0

        ];end ask firms

      let Dividend?        max list 0 ((Profit? - Profit) * DividendPayoutRatio)
      ask Households with [Worker? = false] [ set DepositBank       DepositBank + (Dividend? / 250) ];the capitalist receive the profit from the bank

      set Profit           Profit?           - Dividend?
      set Equity_Loans     Loans?
      set Equity_K-Firms   sum [DepositBank] of Firms      with [K-Firms?]
      set Equity_C-Firms   sum [DepositBank] of Firms      with [not K-Firms?]
      set Equity_Rentists  sum [DepositBank] of Households with [not Worker?]
      set Equity_Workers   sum [DepositBank] of Households with [Worker?]
      set Equity_Total     Equity_Loans + Equity_K-Firms + Equity_C-Firms + Equity_Rentists + Equity_Workers + Profit

    ];end ask banks

    set betha01 betha v1 v2
    set alpha01 alpha (mean v1) (mean v2) betha01
    set betha02 betha v3 v4
    set alpha02 alpha (mean v3) (mean v4) betha02

end

;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------------Optional, population growth ------------------------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________

to growPopulation
  if NewWorkers? = true [
    create-Households %Grow / 100 * count (Households with [Worker? = true]) [
    setxy                 random 10 random 25
    set shape             "person"
    set size              0.65
    set color             blue
    set Worker?           true
    set HumanWealth       0
    set ConsumeDesire     0
    set DepositBank       InitialHouseholdsAssets
    ask Banks             [ set Equity_Workers    Equity_Workers + InitialHouseholdsAssets ]
    set Hired?            false
    set Income            0
    ]

  ask Banks [
    set Equity_Total     InitialEquityBank + Equity_K-Firms + Equity_C-Firms + Equity_Rentists + Equity_Workers
    ]
  ]
end


;__________________________________________________________________________________________________________________________________________________________________________________________

;--------------------------------------------------------------------------------------------Energy Market -------------------------------------------------------------------------
;__________________________________________________________________________________________________________________________________________________________________________________________


to EnergyMarket
  
  if Regulation = "FreeEnergy" [
    ask FirmEnergs [ 
      set ForecastError Production - Demand
      ifelse ForecastError > 0 and Price < LevelPriceE [ 
        set Production Production - (Production * (1 - QtdAdjParam))
      ] [ 
      if ForecastError < 0 and Price > LevelPriceE [ set Production Production + Production * (1 - QtdAdjParam) ]
      ];end ifelse forecasterror
      
      if ForecastError > 0 and Price >= LevelPriceE [ set Price Price * (1 - (random-float 1 * 0.1)) * (1 + ((random-float 1 * NaturalResources) - (NaturalResources / 2)))]
      if ForecastError < 0 and Price <= LevelPriceE [ set Price Price * (1 + (random-float 1 * 0.1)) * (1 + ((random-float 1 * NaturalResources) - (NaturalResources / 2)))]      
      
      set Demand 0
      
    ];end ask energyFirms
  ]
  
    if Regulation = "IndexPrice" [
    ask FirmEnergs [ 
      set ForecastError Production - Demand
      ifelse ForecastError > 0 and Price < LevelPriceE [ 
        set Production Production - (Production * (1 - QtdAdjParam))
      ] [ 
      if ForecastError < 0 and Price > LevelPriceE [ set Production Production + Production * (1 - QtdAdjParam) ]
      ];end ifelse forecasterror
      
      ;if ForecastError > 0 and Price >= LevelPrice [ set Price Price * (1 - (random-float 1 * 0.1))]
      if ForecastError < 0 and Price <= LevelPrice [ set Price Price * (1 + (random-float 1 * 0.1)) * (1 + ((random-float 1 * NaturalResources) - (NaturalResources / 2)))]      
      
      set Demand 0
      
    ];end ask energyFirms
  ]
  
    if Regulation = "CostPrice" [
    ask FirmEnergs [ 
      set ForecastError Production - Demand
      ifelse ForecastError > 0 and Price < LevelPriceE [ 
        set Production Production - (Production * (1 - QtdAdjParam))
      ] [ 
      if ForecastError < 0 and Price > LevelPriceE [ set Production Production + Production * (1 - QtdAdjParam) ]
      ];end ifelse forecasterror
      
      set Price max list Price (Price * (1 + ((random-float 1 * NaturalResources) - (NaturalResources / 2))))
      
      set Demand 0
      
    ];end ask energyFirms
  ]  
  
  
  set LevelPriceE   mean [Price]     of FirmEnergs
  set EnergyProduce sum [Production] of FirmEnergs

  
end




;initial tests to include the logistic equation to model de interests rates pratice for the bank management

to-report betha [ X Y ]

  let meanX     mean   X
  let meanY     mean   Y
  let firstpart (map [((?1 - meanX) * (?2 - meanY))] X Y)
  let secndpart (map [((?  - meanX) * (?  - meanX))] X)
  ifelse  sum secndpart != 0 [ report        (sum firstpart) / (sum secndpart) ] [ report 0 ]

end

to-report alpha [ X Y B ]

  report Y - B * X

end









@#$#@#$#@
GRAPHICS-WINDOW
865
10
1110
541
-1
-1
20.0
1
10
1
1
1
0
1
1
1
0
9
0
24
1
1
1
Period
30.0

BUTTON
5
10
69
43
Setup
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
69
10
149
43
GoOnce!
Go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
148
10
243
43
GoForever!
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
243
10
331
70
NumberWorkers
3000
1
0
Number

SLIDER
331
10
472
43
N_Prod
N_Prod
0
1
0.5
0.05
1
NIL
HORIZONTAL

SLIDER
331
42
472
75
K_Prod
K_Prod
0
1
0.33
0.01
1
NIL
HORIZONTAL

INPUTBOX
470
10
570
76
HumWealthParam
0.96
1
0
Number

INPUTBOX
816
10
866
78
Wage
1
1
0
Number

INPUTBOX
472
198
522
258
ProbInv
0.25
1
0
Number

INPUTBOX
559
257
625
317
InitialPrice
2
1
0
Number

INPUTBOX
702
200
865
260
InitialEquityBank
3000
1
0
Number

INPUTBOX
717
10
816
78
InitialProdK-Firms
3
1
0
Number

INPUTBOX
624
258
702
318
InitialLiquidity
10
1
0
Number

INPUTBOX
522
199
612
259
RiskFreeIntRate
0.01
1
0
Number

INPUTBOX
731
141
865
201
InitialProdC-Firms
5
1
0
Number

INPUTBOX
471
140
523
200
K_initial
10
1
0
Number

INPUTBOX
674
76
797
142
InitialHouseholdsAssets
2
1
0
Number

INPUTBOX
612
200
702
260
DepBankParam
0.05
1
0
Number

INPUTBOX
520
75
675
142
DividendPayoutRatio
0.2
1
0
Number

INPUTBOX
652
141
732
201
QtdAdjParam
0.9
1
0
Number

INPUTBOX
471
75
521
142
MemInv
0.5
1
0
Number

INPUTBOX
602
140
652
200
Depr
0.02
1
0
Number

INPUTBOX
656
10
717
77
DesCapUt
0.85
1
0
Number

INPUTBOX
797
77
865
141
Tc
25
1
0
Number

INPUTBOX
569
10
656
76
InstallmentDebt
0.05
1
0
Number

INPUTBOX
472
257
559
317
BankLossParam
0.0020
1
0
Number

INPUTBOX
522
141
602
201
BankMarkup
1.2
1
0
Number

SWITCH
703
260
817
293
NewWorkers?
NewWorkers?
1
1
-1000

INPUTBOX
816
259
866
319
%Grow
1
1
0
Number

PLOT
1369
10
1840
160
GDP
NIL
NIL
0.0
10.0
10000.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if ticks > 200 [plot GDP]"

PLOT
1368
160
1840
310
Unemployment rate
NIL
NIL
0.0
10.0
3000.0
0.0
true
false
"" ""
PENS
"default" 1.0 0 -8053223 true "" "if ticks > 200 [plot UnEmpRate]"

PLOT
1368
309
1840
459
Price Level
NIL
NIL
0.0
5.0
2000.0
0.0
true
false
"" ""
PENS
"C-Price" 1.0 0 -16777216 true "" "if ticks > 200 [plot LevelPrice]"
"K_Price" 1.0 0 -1184463 true "" "if ticks > 200 [plot LevelPriceK]"

MONITOR
5
42
70
87
Unemp_Rate
UnEmpRate * 100
2
1
11

MONITOR
70
42
149
87
GDP
GDP
0
1
11

MONITOR
149
42
243
87
Price_Level
LevelPrice
2
1
11

TEXTBOX
1116
137
1266
175
Continue ->>
15
0.0
1

SLIDER
6
281
186
314
NaturalResources
NaturalResources
0
.1
0.05
0.01
1
NIL
HORIZONTAL

TEXTBOX
12
236
179
278
Variance into the natural resources, needed at the production of energy system:
11
0.0
1

INPUTBOX
22
388
135
448
EnergiesCompanies
10
1
0
Number

TEXTBOX
32
342
136
384
Total of Firms offering electricity in this Economy:
11
0.0
1

PLOT
286
347
486
497
Energy Price
NIL
NIL
0.0
10.0
3.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if ticks > 0 [plot LevelPriceE]"

MONITOR
211
144
293
189
Energy Price
LevelPriceE
2
1
11

MONITOR
335
140
449
185
Energy Production
EnergyProduce
0
1
11

CHOOSER
222
224
360
269
Regulation
Regulation
"FreeEnergy" "IndexPrice" "CostPrice"
1

@#$#@#$#@
## WHAT IS IT?

This is a Macroeconomic Agent Based Model.

The financial-economic crisis has lead a change in the way of thinking of economist and policy makers. The contribution of this kind of work we have here is to try to create a virtual world based in the individual decision for consumer, and firms. The Agente Based Model will be the aggregation of all the individual decision. The beauty of this area is that the individuals will do not need to follow any axiom or do not need to solve any complex equation, the information are limited and there is cost of transaction, etc. So, this work is near of the family models of Azenza et al. (2015) and Delli Gatti et al. (2011).

## HOW IT WORKS

We simulate an economy with two kinds of Firms: (i) Firms that will produce Capital; and (ii) Firms which will produce final goods. There is some numbers of workers, which also are the consumers in this model, the workers offer worker force to the firms and receive a wage for this. If the workers has no job he try to find one visiting some amount of Firms. The productivity of capital and Labor are taken as constant in this model, as well as the wage; the wage are the same for the both kind Firms, so the workers will accept the first job offer he receive.

## HOW TO USE IT

You just need to click in "Setup", and then click "Go Once" or "Go Forever". Each house represent one Firm, and each person we see represent one worker.

## THINGS TO NOTICE

Look at the series of the Unemployment rate, note they are workers which are able to work and don't find a job, this reflect in the series of the GDP, that means, the production in this economy is not the full, there is some gap between the potential GDP and the actual GDP. The other graphics show the series of prices, the level price in the Capital goods, and the level price in the consumer goods.

## THINGS TO TRY

This is the first version of the model, but we already can see some interesting things emerged in these simulations. For exemple, try to change a little the productivity of Labor - the first slider option - and take a look what happen with the series of the Unemployment rate below.

## EXTENDING THE MODEL

The next steps will probably be to introduce the option to storage goods into the Firm's environment, include a possibility to negotiate wages, and so on, the possibilities are wide.

## CREDITS AND REFERENCES

Details about this framework you may contact us: elder0055@gmail.com
Also, there are some papers which could be very helpful, here are some:

Assenza, Tiziana, Domenico Delli Gatti, and Jakob Grazzini. "Emergent dynamics of a macroeconomic agent based model with capital and credit." Journal of Economic Dynamics and Control 50 (2015): 5-28.

Gatti, Domenico Delli, et al. Macroeconomics from the Bottom-up. Vol. 1. Springer Science & Business Media, 2011.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Energy_Test" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>ticks &gt; 99</exitCondition>
    <metric>ticks</metric>
    <metric>LevelPrice</metric>
    <metric>LevelPriceE</metric>
    <metric>EnergyProduce</metric>
    <metric>GDP</metric>
    <enumeratedValueSet variable="InitialProdC-Firms">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Depr">
      <value value="0.02"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InstallmentDebt">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="BankLossParam">
      <value value="0.0020"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InitialPrice">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="HumWealthParam">
      <value value="0.96"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="DesCapUt">
      <value value="0.85"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="EnergiesCompanies">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="NewWorkers?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InitialEquityBank">
      <value value="3000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="NumberWorkers">
      <value value="3000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="QtdAdjParam">
      <value value="0.9"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Tc">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InitialHouseholdsAssets">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="DepBankParam">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="K_initial">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="K_Prod">
      <value value="0.33"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ProbInv">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Wage">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InitialProdK-Firms">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="InitialLiquidity">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="N_Prod">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="MemInv">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Regulation">
      <value value="&quot;IndexPrice&quot;"/>
      <value value="&quot;FreeEnergy&quot;"/>
      <value value="&quot;CostPrice&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="BankMarkup">
      <value value="1.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="DividendPayoutRatio">
      <value value="0.2"/>
    </enumeratedValueSet>
    <steppedValueSet variable="NaturalResources" first="0.01" step="0.01" last="0.1"/>
    <enumeratedValueSet variable="RiskFreeIntRate">
      <value value="0.01"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%Grow">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
