patches-own [ oasis-scent 
  chemical energy origin? origin-scent outer? inner? outer-scent inner-scent value food nimmer repressor salue ]
turtles-own [ HoxB4 GATA1 ]
breed [ hemangioAs hemangioA ]
breed [ hemangioBs hemangioB ]
breed [ hemangioCs hemangioC ]
breed [ lot lots ]
breed [ alot alots ]
breed [ blot blots ]
breed [ clot clots ]
breed [ dlot dlots ]
breed [ elot elots ]
breed [ flot flots ]
breed [ glot glots ]
breed [ hlot hlots ]
breed [ ilot ilots ]
breed [ jlot jlots ]
breed [ klot klots ]
breed [ llot llots ]
breed [ slot slots ]
breed [ tlot tlots ]
breed [ oasis oasi ]
breed [ linings lining ]
breed [ pulps pulp ]
breed [ meta metas]
breed [ endos endo ]
breed [ bloodcs bloodc ]
breed [ BIs BI ]

breed [ niches niche ]

globals [ range ]

breed [ drawer ]


to setup
  clear-all
  setup-BIs
  setup-oasis
  setup-niches
  setup-hemangios
  setup-hemangioCs
end


to setup-BIs
  ask patches [ if (pycor = 14 ) [ set inner-scent 20 set pcolor cyan ] ]
  ask patches [ if (pycor = 14 ) [ sprout-BIs 1 ] ]
  ask patches [ if (pycor = 13 ) [ set outer-scent 30 set pcolor lime ] ]
  ask patches [ if (pycor = 13 ) [ sprout-BIs 1 ] ]
  
end

to setup-oasis
 create-lot 2
  ask lot [ setxy 0 -8 facexy random-xcor 0  set color white 
  set breed oasis  set value Number  ] 
   create-alot 2
   ask alot [ setxy -10 -7 facexy random-xcor 0  set color white 
   set breed oasis  set value Number  ] 
    create-blot 2
    ask blot [ setxy 10 -7 facexy random-xcor 0  set color white 
    set breed oasis  set value Number  ] 
      create-clot 2
      ask clot [ setxy -5 -3 facexy random-xcor 0  set color white 
      set breed oasis  set value Number  ] 
        create-dlot 2
        ask dlot [ setxy 5 -3 facexy random-xcor 0  set color white 
        set breed oasis set value Number  ] 
          create-elot 2
          ask elot [ setxy 0 0 facexy random-xcor 0  set color white 
           set value Number  set breed oasis] 
            create-flot 2
            ask flot [ setxy -10 0 facexy random-xcor 0  set color white 
             set value Number  set breed oasis] 
              create-glot 2
              ask glot [ setxy 10 0 facexy random-xcor 0  set color white 
               set value Number  set breed oasis] 
                 create-hlot 2
                 ask hlot [ setxy -5 3 facexy random-xcor 0  set color white 
                  set value Number  set breed oasis] 
                   create-ilot 2
                   ask ilot [ setxy 5 3 facexy random-xcor 0  set color white 
                    set value Number  set breed oasis] 
                      create-jlot 2
                      ask jlot [ setxy 10 7 facexy random-xcor 0  set color white 
                       set value Number  set breed oasis] 
                         create-klot 2
                         ask klot [ setxy -10 7 facexy random-xcor 0  set color white 
                          set value Number  set breed oasis]
                             create-llot 2
                             ask llot [ setxy 0 7 facexy random-xcor 0  set color white 
                              set value Number  set breed oasis]    
  create-slot 1
    ask slot [   setxy 0 2  facexy random-xcor 0  set color white  
       set value Number set size 1 set breed oasis] 

    create-tlot 1
    ask tlot [   setxy 9 7  facexy random-xcor 0  set color white  
       set value Number set size 1 set breed oasis] 
 
      ask oasis [ ask n-of oasisnumber patches in-radius 3 
    [  sprout-bloodcs 1 
      sprout-endos 1  ] ] 
  ask oasis [ set chemical oasisCONC ]
    
    
    
end


to setup-niches
     create-drawer 1 [   setxy 0 -14  facexy 0 0   ]
      ask drawer
  [ hatch-niches nichenombre set breed niches ]
  ask niches [ set size 4 facexy 0 0 rt random 360 fd nichestep ]
    ask niches [ if (pycor < -12 ) [ die ] ]
   
  ask drawer [ die ]
    ;; ask patches [  if (pycor > 12 ) [ set outer-scent 20 set pcolor cyan ] ]
end


to setup-hemangios
  create-hemangioAs 1
    ask hemangioAs [ setxy 1 -14 facexy random-xcor 0  set color white 
      set shape "target" set value Number set size 3] 
create-hemangioBs 1
    ask hemangioBs [   setxy -1 -14  facexy random-xcor 0  set color grey  
      set shape "target" set value Number set size 3] 
 ;; create-hemangioCs 1
  ;;   ask hemangioCs [   setxy 1 -14  facexy random-xcor 0  set color magenta set shape "target" set value Number ]  
end

to setup-hemangioCs
  create-hemangioCs 1 [ setxy 0 -16 facexy random-xcor 0 set color white
    set shape "target" set value Number set size 1 ]
end


to go
 ;; ask patches [  if (pycor > 12 ) [ set outer-scent 20 set pcolor cyan ] ]
  
    ask hemangioAs [ set value random steadyrate ]
    ask hemangioAs  [ if ( value < 2 ) and divide1?
         [ hatch 1 set breed endos 
           set shape "cell" set color lime set size 2] 
         ] 
     ;; type 2 division 
    ask hemangioAs [ if ( value < 2 and divide2? )
         [ hatch 1 set breed bloodcs 
           set shape "cloud" set color lime set size 2] 
           ] 
       
    ask hemangioBs [ set value random steadyrate ]
    ask hemangioBs  [ if ( value < 2 ) and divide1?
         [ hatch 1 set breed bloodcs 
           set shape "cloud" set color lime set size 2] 
         ] 
     ;; type 2 division 
    ask hemangioBs [ if ( value < 2 and divide2? )
         [ hatch 1 set breed endos 
           set shape "cell" set color lime set size 2 ] 
           ] 
    
    ask hemangioCs [ set salue random HSCrate ]
    ask hemangioCs  [ if ( salue < 1 ) and divide1?
         [ hatch 1 set breed meta 
           set shape "cloud" set color yellow set size 5 set HoxB4 random-float 50 set GATA1 random-float 50 ] 
         ] 
     ;; type 2 division 
;    ask hemangioCs [ if ( salue < 1 ) and divide2? 
 ;        [ hatch 1 set breed meta 
   ;        set shape "cell" set color yellow set size 4 set GATA1 random-float 50 set HoxB4 random-float 50] 
     ;     ] 

;;  Green endos migration rules:
   if any? endos with [ shape = "cell" ] 
  [ ask endos
  [ if chemical > sniff-threshold                  ;; ignore pheromone unless there's enough here
      [ turn-toward-chemical ]
    rt random-float wiggle-angle - random-float wiggle-angle + wiggle-bias
    fd 0.1
    set chemical chemical + cellCONC ]                    ;; drop chemical onto patch
  diffuse chemical 1                               ;; diffuse chemical to neighboring patches
  
  ask patches
  [ set chemical chemical * nicheDIFF                     ;; evaporate chemical
    set pcolor scale-color green chemical 0.1 20 ]]  ;; update display of chemical concentration
   if any? endos with [ shape = "cell" ] [ ask endos [ if outer-scent = 30 [ hatch-linings 1 set color lime die ]]]
   ask linings [set shape "cell"]
  
;;  Red bloodcs migration rules:
  
  if any? bloodcs with [ shape = "cloud" ] [ ask bloodcs 
  [ if chemical > sniff-threshold                  ;; ignore pheromone unless there's enough here
      [ turn-toward-chemical ]
    rt random-float wiggle-angle - random-float wiggle-angle + wiggle-bias
    fd 0.1
    set chemical chemical + cellCONC ]                    ;; drop chemical onto patch
  diffuse chemical 1                               ;; diffuse chemical to neighboring patches
  
    ask bloodcs [ if ycor > 12 
         [ set color red ] 
           ] 
    
  ask patches
  [ set chemical chemical * nicheDIFF                    ;; evaporate chemical
    set pcolor scale-color blue chemical 0.1 10 ]]  ;; update display of chemical concentration
   if any? bloodcs with [ color = magenta ] [ ask bloodcs [ if inner-scent = 20 [ hatch-pulps 1 set color magenta die ]]]
   ask pulps [set shape "cloud" set size 2]
   
   ;;  HSC migration rules:
  
  if any? meta with [ color = yellow ] [ ask meta 
  [ if chemical > sniff-threshold                  ;; ignore pheromone unless there's enough here
      [ turn-toward-chemical ]]
   ask meta [
      rt random-float wiggle-angle - random-float wiggle-angle + wiggle-bias
    fd 0.1
    set chemical chemical + nicheCONC                     ;; drop chemical onto patch
    set GATA1 GATA1 + random-float 5
    set HoxB4 HoxB4 + random-float 5 ] ]
  
   if any? meta with [ color = yellow ]
  [ ask meta [
     if ( GATA1 - HoxB4 > 0 ) and ( abs GATA1 - HoxB4 > threshold-difference ) 
     [ set color 15 set breed bloodcs set shape "cloud" set size 5 ] ] ]
  
     if any? meta with [ color = yellow ]
  [ ask meta [
     if ( HoxB4 - GATA1 > 0 ) and ( abs HoxB4 - GATA1 > threshold-difference ) 
     [ set color 72 set breed endos set shape "cell" set size 5 ] ] ]
  ;; ****
       
    
  diffuse chemical 1                               ;; diffuse chemical to neighboring patches
  
  ask patches
  [ set chemical chemical * nicheDIFF                    ;; evaporate chemical
    set pcolor scale-color blue chemical 0.1 10 ]  ;; update display of chemical concentration
   if any? meta with [ color = magenta ] [ ask meta [ if inner-scent = 20 [ hatch-pulps 1 set color magenta die ]]]
   ask pulps [set shape "cloud" set size 2]
  
  tick
  
  
 ask niches
    [ set chemical chemical + ( nichebias * nicheCONC ) ]                    ;; drop chemical onto patch
  diffuse chemical nicheDIFF                               ;; diffuse chemical to neighboring patches
  ask patches
  [ set chemical chemical * 0.9                    ;; evaporate chemical
    set pcolor scale-color blue chemical 0.1 10 ] 
 ask niches [ if hideturtle? [ ht ]]
 
 ask oasis
   [ set chemical chemical + ( 20 * nichebias * nicheCONC ) ]                    ;; drop chemical onto patch
  diffuse chemical nicheDIFF                               ;; diffuse chemical to neighboring patches
  ask patches
  [ set chemical chemical * 0.9                    ;; evaporate chemical
    set pcolor scale-color blue chemical 0.1 10 ] 
 ask oasis [ if hideturtle? [ ht ]]
 
 
 ask BIs [ if hideturtle? [ ht ]]
   ask BIs [ set chemical chemical + ( BI-CONC * nichebias * nicheCONC ) ]                    ;; drop chemical onto patch
  diffuse chemical nicheDIFF                               ;; diffuse chemical to neighboring patches
  ask patches
  [ set chemical chemical * 0.9                    ;; evaporate chemical
    set pcolor scale-color blue chemical 0.1 10 ] 
 
  end
  
  to turn-toward-chemical  ;; turtle procedure
  ;; examine the patch ahead of you and two nearby patches;
  ;; turn in the direction of greatest chemical
    let ahead 0
  let myright 0
  let myleft 0
  let sniffed-patch patch-ahead 2
  if sniffed-patch != nobody [
    set ahead [chemical] of sniffed-patch
  ]
  set sniffed-patch patch-right-and-ahead sniff-angle 2
  if sniffed-patch != nobody [
    set myright [chemical] of sniffed-patch
  ]
  set sniffed-patch patch-left-and-ahead sniff-angle 2
  if sniffed-patch != nobody [
    set myleft [chemical] of sniffed-patch
  ]
  ifelse (myright >= ahead) and (myright >= myleft)
  [ rt sniff-angle ]
  [ if myleft >= ahead
    [ lt sniff-angle ] ]
end

 ;;    ask bloodc 543 [ print hoxb4 ] to get hoxb4/gata1 levels
@#$#@#$#@
GRAPHICS-WINDOW
210
10
772
593
16
16
16.73
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks

BUTTON
20
51
86
84
NIL
setup\\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
116
51
179
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
2
231
110
264
divide1?
divide1?
0
1
-1000

SWITCH
101
231
207
264
divide2?
divide2?
0
1
-1000

SLIDER
8
336
180
369
oasisCONC
oasisCONC
0
20
8
.1
1
NIL
HORIZONTAL

SLIDER
8
301
180
334
oasisnumber
oasisnumber
1
12
7
1
1
NIL
HORIZONTAL

SLIDER
776
231
948
264
SNIFF-THRESHOLD
SNIFF-THRESHOLD
0
10
2
0.1
1
NIL
HORIZONTAL

SLIDER
776
324
948
357
wiggle-angle
wiggle-angle
0
90
24
1
1
NIL
HORIZONTAL

SLIDER
776
288
948
321
wiggle-bias
wiggle-bias
-90
90
0
1
1
NIL
HORIZONTAL

SLIDER
776
197
948
230
sniff-angle
sniff-angle
0
90
16
1
1
NIL
HORIZONTAL

SLIDER
13
137
185
170
steadyrate
steadyrate
0
500
48
1
1
NIL
HORIZONTAL

SLIDER
14
511
186
544
nicheDIFF
nicheDIFF
0
1
0.7
0.1
1
NIL
HORIZONTAL

SLIDER
14
477
186
510
nicheCONC
nicheCONC
0
10
10
0.1
1
NIL
HORIZONTAL

SLIDER
14
442
186
475
nichebias
nichebias
0
100
2
1
1
NIL
HORIZONTAL

SWITCH
779
472
902
505
hideturtle?
hideturtle?
0
1
-1000

SLIDER
5
267
177
300
BI-CONC
BI-CONC
0
20
8.9
0.1
1
NIL
HORIZONTAL

SLIDER
14
408
186
441
nichestep
nichestep
5
15
7
1
1
NIL
HORIZONTAL

SLIDER
14
374
186
407
nichenombre
nichenombre
0
200
54
1
1
NIL
HORIZONTAL

SLIDER
13
102
185
135
NUMBER
NUMBER
0
500
111
1
1
NIL
HORIZONTAL

SLIDER
776
52
945
85
threshold-difference
threshold-difference
5
200
86
1
1
NIL
HORIZONTAL

SLIDER
13
171
185
204
HSCrate
HSCrate
100
1000
576
1
1
NIL
HORIZONTAL

SLIDER
14
545
186
578
cellCONC
cellCONC
0
5
0
0.1
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This model seeks to formalize the coordination of interactions that is required to generate blood and endothelial distribution patterns in the yolk sac at mouse headfold stages. 
Specifically, it focuses on the requirements necessary to understand the stochastic interactions that influence hemangioblast determination, as marked by balanced nuclear HoxB4 and GATA1 levels, and its positioning.  

HOW IT WORKS
------------
Rules are modified from Ants and Slime.

All cells move based on their ability to sense a nutrition/chemical/food/ligand gradient at a specific distance from its current patch across a radial arc.  The agents will then respond by moving towards the higher gradient in a probabilistic manner but are also constrained in the distance and angle of movement.

Some patches secrete chemicals.  These patches are distributed across different regions; the blood islands (BI) are located at the top, oasis is the middle migration zone and the nook, an area marked by the arc of large triangle forms, which represents the contact region between the Ventral Cuboidal Mesothelium (VCM) and transitional visceral endoderm (AX) that sits close to the targets (epiblast/allantoic core domain (ACD)) at the bottom.

The targets are the source of new cells that migrate out of the epiblast or ACD.  Green endothelial cells that do not have hematopoietic potential come out of the two large targets to generate the primary plexus.  Large yellow clouds that represent hemangioblasts making the endothelial/erythroid choice come out of the little target.  Each of these large clouds are assigned an initial value between 0 and 50 and adds a random value between 1 and 5 with each tick.  When the difference gets greater than "threshold-difference", AND GATA1value > HOXB4value, then the cloud changes its color to red.  If HOXB4value > GATA1value, the cloud changes to green, and becomes an angioblast.  If it stays within the range of the "threshold-difference", it stays yellow, and thus, a hemangioblast. 

HOW TO USE IT
-------------

steadyrate controls the rate of endothelial cell generation
HSCrate controls the rate of HSC generation
Divide1/Divide2 controls the type of endothelial cells that come out
All sliders below that aid in placing the chemical sources and their relative strengths.

All sniff and wiggle sliders control chemical sensing and movement response.

Threshold-difference determines at what range the choice between endothelial and erythroid cell is made.

On/Off hideturtle? switch controls whether you see the patch sources.


THINGS TO NOTICE
----------------

Where do the cells tend to congregate the most?

Do any two cells move together?

What's the spatial relationship between large yellow, green and red clouds over time?


THINGS TO TRY
-------------

Try making different arrangements.  What's required to make those configurations?  How is this environment produced in such a reproducible manner in the yolk sac?  What actually executes these programs?

Chart the difference in specific cells over time.

Set an upper limit for threshold-difference based on cell distributions.

Set a lower limit for threshold-difference.

EXTENDING THE MODEL
-------------------

Will adding adhesion rules change anything? 

How about cell division rules? 


RELATED MODELS
--------------

    The patterns of movement of the endothelial cells and the blood cells and their ability to sense the chemical around them were adopted from the Ants and Slime models in the netlogo library. 


CREDITS AND REFERENCES
----------------------

To refer to this model in academic publications, please use: Wilensky, U. (1997). NetLogo Slime model. http://ccl.northwestern.edu/netlogo/models/Slime. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
In other publications, please use: Copyright 1997 Uri Wilensky. All rights reserved. See http://ccl.northwestern.edu/netlogo/models/Slime for terms of use.

Rhee, Jerry M., Iannaccone, Philip M., Mapping mouse hemangioblast maturation from headfold stages, Developmental Biology (2012), 
doi:10.1016/j.ydbio.2012.02.023

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

cell
true
0
Polygon -7500403 true true 150 210 135 225 120 210 90 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 75 90 105 30 105 105 105 60 120 60 135 30 150 15 165 30 180 60 195 60 195 30 210 60 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 225 165 210 180 180 210 165 225
Polygon -7500403 true true 120 180 105 240 75 255 150 285 225 255 195 240 165 180

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cloud
false
0
Circle -7500403 true true 13 118 94
Circle -7500403 true true 86 101 127
Circle -7500403 true true 51 51 108
Circle -7500403 true true 118 43 95
Circle -7500403 true true 158 68 134

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 30 30 180
Line -7500403 true 120 60 120 210

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 75 165 300
Polygon -7500403 true true 135 210 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 210 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 135 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 135 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 90 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 90 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
