globals [
 badger-pxcor
 badger-pycor
 agent-near
 speed
 squirrel-speed
 badger-eats-squirrel
 coyote-eats-squirrel
 squirrel-survives
 squirrel-survives-counter
 squirrels-who
]

breed [badgers badger]
breed [coyotes coyote]
breed [squirrels squirrel]
;breed [acorns acorn]

badgers-own [badger-adrenaline badger-speed squirrel-near?]
coyotes-own [coyote-adrenaline coyote-speed squirrel-near?]

squirrels-own [
  chased-by-coyote?
  chased-by-badger?
  coyote-near?
  badger-near?
  fear
  exhaustion
]

patches-own [
  predator-scent
  prey-scent
]


to go
  set squirrel-survives squirrel-survives + 1
  ;if squirrel-survives > squirrel-survives-at-ticks [
  ;  reset-ticks
  ;  show "The squirrel survived another day!"
  ;  set squirrel-survives-counter squirrel-survives-counter + 1
  ;]

  if not any? squirrels [
    ;reset-ticks how to do this?
    wait 2
    clear-turtles
    create-agents
  ]

    ;create-squirrels 1 [
    ;setxy (5 - random 20) 4
    ;set color red
    ;set size 0.75
    ;set heading 90
    ;set chased-by-coyote? False
    ;set coyote-near? False
    ;set badger-near? False] ]

  ;if ticks >= squirrel-survives-at-ticks [set squirrel-survives squirrel-survives + 1]
  ; how to do this?

  move-badgers
  move-coyotes
  move-squirrels

  ask patches [
    if prey-scent >= 0.1 [set prey-scent prey-scent - 0.05]
    if predator-scent >= 0.1 [set predator-scent predator-scent - 0.05]
  ]

  tick
end

;;;;;;;;;;;; create agents (badger, coyote, squirrel) ;;;;;;;;;;;;;;;;;;;;

to create-agents
    create-badgers 1 [setxy (12 - random 24) -7
    set color white
    let random-heading random 2
    ifelse random-heading = 0 [set heading 90] [set heading 270]
    ifelse badger? [st set badger-speed 0.185] [ht set badger-speed 0]
    set squirrel-near? False]

  create-coyotes 1 [
    ifelse coyote? [st set coyote-speed 0.2 setxy (5 + random 10) 4] [ht set coyote-speed 0 setxy (5 + random 10) -7]
    set size 1.5
    set color brown
    let random-heading random 2
    ifelse random-heading = 0 [set heading 90] [set heading 270]
    set squirrel-near? False]

  create-squirrels 1 [
    setxy (5 - random 20) 4
    set color red
    set size 0.75
    let random-heading random 2
    ifelse random-heading = 0 [set heading 90] [set heading 270]
    set chased-by-coyote? False
    set coyote-near? False
    set squirrel-speed 0.2
    set badger-near? False
    ]
end

;;;;;;;;;;;; move commands for agents ;;;;;;;;;;



to move-badgers
  ask badgers [
    if [pcolor] of patch-ahead 1 != black and [pcolor] of patch-left-and-ahead 90 1 = black [lt 90]
    if [pcolor] of patch-ahead 1 != black and [pcolor] of patch-right-and-ahead 90 1 = black [rt 90]
    let random-turn random 100
    if random-turn = 50 and not any? squirrels in-radius 5 [rt 180]
    ifelse can-move? 1 and [pcolor] of patch-ahead 1 = black
    [fd badger-speed]
    [rt 180]

    let prey one-of squirrels-here
    if prey != nobody [
      ask prey [ die ]
      set badger-eats-squirrel badger-eats-squirrel + 1]

    ask patch-here [set predator-scent predator-scent + 1]
    ;ifelse patch-here predator-scent = 0 ;; need to ask patch's value for this var

  ]
end

to move-coyotes
  ask coyotes [
    squirrel-near-coyote?
    ifelse coyote-adrenaline >= 1 [set coyote-speed 0.30] [set coyote-speed 0.20]
    if coyote-adrenaline > 0 [set coyote-adrenaline coyote-adrenaline - 0.5]
    let random-turn random 100
    if random-turn = 50 and not any? squirrels in-radius 6 [rt 180]
    ifelse can-move? 1 and [pcolor] of patch-ahead 1 = green
    [fd speed]
    [rt 180]
    ask patch-here [set predator-scent predator-scent + 1]

    let prey one-of squirrels-here
    if prey != nobody [
      ask prey [ die ]
      set coyote-eats-squirrel coyote-eats-squirrel + 1
    ] ;show ["the squirrel was eaten!"]]

  ]
end

to move-squirrels


  ask squirrels [
    ;; could have an underground procedure/state if patch color here = black, true
    ;; squirrel needs to be able to come back up from underground ...
    ;chase-by-coyote?

    coyote-near-squirrel?
    badger-near-squirrel?

    if fear > 0 [set fear fear - 0.5]
    ifelse fear > 0 [set squirrel-speed 0.25] [set squirrel-speed 0.15]

    if [pcolor] of patch-here = black and [pcolor] of patch-ahead 1 = green [
      fd 1
      let random-turn random 2
      ifelse random-turn = 1 [ rt 90 ] [ lt 90]
    ]
    if (chased-by-coyote? or coyote-near?) and [pcolor] of patch-left-and-ahead 90 1 = black [lt 90]
    if (chased-by-coyote? or coyote-near?) and [pcolor] of patch-right-and-ahead 90 1 = black [rt 90]


    ifelse can-move? 1 and ([pcolor] of patch-ahead 1 = green or [pcolor] of patch-ahead 1 = black)
    [fd squirrel-speed]
    [rt 180]
    ask patch-here [set prey-scent prey-scent + 1]

  ]
end


;;;;;;; chase search run ;;;;;;;

to squirrel-near-coyote?
  if not squirrel-near? [
  if any? squirrels in-radius 5

    [
      set squirrel-near? True set coyote-adrenaline coyote-adrenaline + 30 ]
  ]

  if not any? squirrels in-radius 5
  [set squirrel-near? False]
end

to prey-near
  ifelse count turtles in-radius 2 = 0
  [set agent-near False]
  [set agent-near True]
end


to coyote-near-squirrel?
  if not coyote-near? [
    if any? coyotes in-radius 3 and [pcolor] of patch-here = green and abs ([heading] of squirrel 2 - [heading] of coyote 1) > 10
    [set coyote-near? True rt 180 set fear fear + 18]]

  if not any? coyotes in-radius 1 and [pcolor] of patch-here = black
  [set coyote-near? False set squirrel-speed 0.15] ;; squirrel slows down underground
end

to badger-near-squirrel?


  if not badger-near?
  [if any? badgers in-radius 2 and [pcolor] of patch-here = black and abs ([heading] of squirrel 2 - [heading] of badger 0) > 10
    [set badger-near? True rt 180 set fear fear + 5]]

  if not any? badgers in-radius 4 and [pcolor] of patch-here = black
  [set badger-near? False set squirrel-speed 0.20]
end

to chase-by-coyote?
  ifelse [predator-scent] of patch-here >= 0.6
  [ask squirrels [set chased-by-coyote? True]]
  [ask squirrels [set chased-by-coyote? False]]
end

to move

end

;;;;;;; report stuff ;;;;;;

to-report badger-eats-squirrel-counter
  report badger-eats-squirrel
end

to-report coyote-eats-squirrel-counter
  report coyote-eats-squirrel
end

;;;;;;;;;;;;;;;;;;;;; world generation ;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape squirrels "squirrel"
  set-default-shape coyotes "wolf"
  set-default-shape badgers "badger"
  ;set-default-shape acorns "acorn"
  make-grass
  make-badger-burrows-dirt
  make-sky
  make-badger-burrows-burrows
  create-agents
  set speed 0.2
  set squirrel-speed 0.2
  set squirrel-survives-counter 0
  reset-ticks
end

to make-grass
  ask patches [if (abs pxcor) < 20 and
    pycor = 4 [set pcolor green]]
end

to make-badger-burrows-dirt
  ask patches [if (abs pxcor) < 20 and pycor < 4 [set pcolor brown]]
end

to make-sky
  ask patches [if pcolor = black [set pcolor blue] ]
end

to make-badger-burrows-burrows
  set badger-pxcor 12
  set badger-pycor 3
  repeat 10 [
  ask patches with
  [pycor = badger-pycor and (abs pxcor) = badger-pxcor]
  [set pcolor black]
  ;; loop through to make vertical part of burrow
  set badger-pycor (badger-pycor - 1)
  ]

 repeat 13 [
  ask patches with
  [pycor = badger-pycor and (abs pxcor) = badger-pxcor]
  [set pcolor black]
  ;; loop through to make vertical part of burrow
  set badger-pxcor (badger-pxcor - 1)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
188
10
936
400
-1
-1
22.42424242424243
1
10
1
1
1
0
0
0
1
-16
16
-8
8
1
1
1
ticks
30.0

BUTTON
4
48
93
81
create world
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
96
49
188
82
move creatures
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

MONITOR
4
84
93
129
coyote eats squirrel
coyote-eats-squirrel-counter
17
1
11

MONITOR
95
84
186
129
badger eats squirrel
badger-eats-squirrel-counter
17
1
11

PLOT
3
132
186
262
creature fear/adrenaline
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" "ask squirrels [\n  create-temporary-plot-pen (word who)\n  set-plot-pen-color red\n  plotxy ticks fear\n]\n\nask coyotes [\n  create-temporary-plot-pen (word who)\n  set-plot-pen-color brown\n  plotxy ticks coyote-adrenaline\n]"
PENS

SWITCH
4
10
94
43
coyote?
coyote?
0
1
-1000

SWITCH
96
10
186
43
badger?
badger?
0
1
-1000

PLOT
3
265
186
400
creature speed
ticks
speed
0.0
10.0
0.0
0.5
true
false
"" "ask squirrels [\n  create-temporary-plot-pen (word who)\n  set-plot-pen-color red\n  plotxy ticks squirrel-speed\n]\n\nask coyotes [\n  create-temporary-plot-pen (word who)\n  set-plot-pen-color brown\n  plotxy ticks coyote-speed\n]"
PENS

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

acorn
false
0
Polygon -7500403 true true 146 297 120 285 105 270 75 225 60 180 60 150 75 105 225 105 240 150 240 180 225 225 195 270 180 285 155 297
Polygon -6459832 true false 121 15 136 58 94 53 68 65 46 90 46 105 75 115 234 117 256 105 256 90 239 68 209 57 157 59 136 8
Circle -16777216 false false 223 95 18
Circle -16777216 false false 219 77 18
Circle -16777216 false false 205 88 18
Line -16777216 false 214 68 223 71
Line -16777216 false 223 72 225 78
Line -16777216 false 212 88 207 82
Line -16777216 false 206 82 195 82
Line -16777216 false 197 114 201 107
Line -16777216 false 201 106 193 97
Line -16777216 false 198 66 189 60
Line -16777216 false 176 87 180 80
Line -16777216 false 157 105 161 98
Line -16777216 false 158 65 150 56
Line -16777216 false 180 79 172 70
Line -16777216 false 193 73 197 66
Line -16777216 false 237 82 252 84
Line -16777216 false 249 86 253 97
Line -16777216 false 240 104 252 96

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

badger
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -16777216 true false 45 195 44 180 66 166 70 153 83 140 112 131 164 133 189 126 255 135 255 150 255 120 270 135 270 135 270 135 270 135 270 135 270 135
Polygon -16777216 true false 45 195 43 197 60 195 68 193 68 205 50 226 60 225 60 225 60 225 60 225 60 225 61 230 90 206 98 198 105 209 96 228 95 243 105 240 105 240 105 240 105 240 107 239 109 231 130 207 128 196 149 201 173 202 190 195 196 210 195 210 195 225 195 240 195 240 195 240 195 240 210 225 210 225 210 210 225 210 225 225 240 225 225 225 240 210 222 198 240 184 255 180 270 180 285 165 285 150 270 135 270 135 270 135 270 135 270 135 270 135
Line -1 false 45 180 270 135
Line -1 false 45 180 90 180
Line -1 false 90 180 210 150
Line -1 false 210 150 270 135
Rectangle -1 true false 135 150 180 165
Polygon -1 true false 135 150 105 165 60 180 90 180 150 165 180 165 210 150 270 135 210 135 180 150 135 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dog
false
0
Polygon -7500403 true true 300 165 300 195 270 210 183 204 180 240 165 270 165 300 120 300 0 240 45 165 75 90 75 45 105 15 135 45 165 45 180 15 225 15 255 30 225 30 210 60 225 90 225 105
Polygon -16777216 true false 0 240 120 300 165 300 165 285 120 285 10 221
Line -16777216 false 210 60 180 45
Line -16777216 false 90 45 90 90
Line -16777216 false 90 90 105 105
Line -16777216 false 105 105 135 60
Line -16777216 false 90 45 135 60
Line -16777216 false 135 60 135 45
Line -16777216 false 181 203 151 203
Line -16777216 false 150 201 105 171
Circle -16777216 true false 171 88 34
Circle -16777216 false false 261 162 30

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

squirrel
false
0
Polygon -7500403 true true 87 267 106 290 145 292 157 288 175 292 209 292 207 281 190 276 174 277 156 271 154 261 157 245 151 230 156 221 171 209 214 165 231 171 239 171 263 154 281 137 294 136 297 126 295 119 279 117 241 145 242 128 262 132 282 124 288 108 269 88 247 73 226 72 213 76 208 88 190 112 151 107 119 117 84 139 61 175 57 210 65 231 79 253 65 243 46 187 49 157 82 109 115 93 146 83 202 49 231 13 181 12 142 6 95 30 50 39 12 96 0 162 23 250 68 275
Polygon -16777216 true false 237 85 249 84 255 92 246 95
Line -16777216 false 221 82 213 93
Line -16777216 false 253 119 266 124
Line -16777216 false 278 110 278 116
Line -16777216 false 149 229 135 211
Line -16777216 false 134 211 115 207
Line -16777216 false 117 207 106 211
Line -16777216 false 91 268 131 290
Line -16777216 false 220 82 213 79
Line -16777216 false 286 126 294 128
Line -16777216 false 193 284 206 285

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment-false" repetitions="2" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="100000"/>
    <metric>coyote-eats-squirrel</metric>
    <enumeratedValueSet variable="badger?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="coyote?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
